

var appStatus = -1,
playing = false, renderEndTime = 0, renderImageURL = null, playHotkey, captureMouse = false,
lockFps = 0, animationTime = 0, animationRefTime = 0, lastTime = 0, currentTime = 0, framerate = 0,
projects = [], project = null,
layers = [], passes = [], layer = null, layerId = 0,

APPSTATUS_SPLASH = -1, APPSTATUS_MAIN = 0, APPSTATUS_PROJECT = 1, APPSTATUS_ABOUT = 2, APPSTATUS_NEWPROJECT = 3, APPSTATUS_OPENPROJECT = 4, APPSTATUS_CONFIGLAYERS = 5,
APPSTATUS_RENDERMENU = 6, APPSTATUS_RENDERING = 7, APPSTATUS_RENDERCOMPLETE = 8,

LAYERTYPE_PASS = 0, LAYERTYPE_SHAREDGLSL = 1, LAYERTYPE_IMAGE = 2, LAYERTYPE_JSON = 3,
LAYERTYPE_NAMES = ["GLSL Render Pass", "Shared GLSL", "Image Texture", "JSON Array Texture"], LAYERTYPE_PASSNAME = [LAYERTYPE_NAMES[0]],
PASSRESOLUTION_DISPLAY = 0, PASSRESOLUTION_FIXED = 1;



//DOM loaded, program entry point
document.addEventListener("DOMContentLoaded",function() {

	if (!InitializeGraphics()) return;	
	InitializeSyntaxHighlighting();
	InitializeUI();
	InitializeMouseKeyboard();
	InitializeStandaloneBuild();
	
	IndexedStorage_Open("GLSLCanvas", function() {
		IndexedStorage_Load("Projects", function(id,data) {
			if (data) {
				//load existing projects
				var pl = JSON.parse(data);
				projects.length = pl.length;
				for (var i = 0; i < pl.length; i++) {
					var d = pl[i];
					projects[i] = new Project(d["i"],d["n"]);
				}
				
				//open first project in list
				project = projects[0];
				IndexedStorage_Load("Project_"+project.id, function(id,data) {
					if (data) {
						ProjectFromJSON(JSON.parse(data));
					}
					
					ExitSplash();
				});
			
			} else {
				//no existing data, first time launching, create first project
				projects.push(project = new Project(0,projectConfig["ProjectName"].value));
				
				layers.push(layer = new PassLayer("New Layer",glslEditor.text.value));
				passes.push(layer);
				layerId = 0;
				
				SaveProjects();
				SaveProject(); 
				
				ExitSplash();
			}
		});
	});

	MainLoop();
});



function ExitSplash() {
	//initialize main panel
	sidebarInput["Layers"].SetSelectOptions(GetLayerNames(), layerId);
	SetSidebarLayer(layerId);
	
	//save on exit listener
	window.addEventListener("beforeunload", function(e) {
		SaveProjects();
		SaveProject();
		e.preventDefault();
		return e.returnValue = "Do you want to leave the site? Changes you made may not be saved.";
	});
	
	//exit splash screen
	appStatus = APPSTATUS_MAIN;
	EV(splashPanel,false);
	EV(mainPanel,true);
}


/*Function: HttpRequest
Create and send HTTP get/post request.

Parameters:
*String* url - Request URL.
*function* callback - Ready state change callback.
*bool* binary - If true response is provided as arraybuffer, if false response is string.
*String* or *TypedArray* postData - POST data either string with url encoded params or typed array containing binary data.

Returns:
*XMLHttpRequest* The request object.*/
function HttpRequest(url,callback,binary,postData) {
	var req = new XMLHttpRequest();
	if (binary) req.responseType = "arraybuffer";
	req.onreadystatechange = callback;
	if (postData) {
		req.open("POST",url);
		req.setRequestHeader("Content-Type", postData.buffer?"arraybuffer":"application/x-www-form-urlencoded");
		req.send(postData);
	} else {
		req.open("GET",url);
		req.send();
	}
	return req;
}

//string replace all polyfill
if (!String.prototype.replaceAll) {
	String.prototype.replaceAll = function(key,rep) {
		var o = "", i = 0;
		while (true) {
			var n = this.indexOf(key, i);
			if (n === -1) {
				o += this.substring(i,this.length);
				break;
			}
			o += this.substring(i, n)+rep;
			i = n+key.length;
		}
		return o;
	}
}


//encode binary string as url safe base64, returns base64
function EncodeURLBase64(data) {
	var b = btoa(data), end = b.length-1, bi = end;
	//remove padding
	while (b[bi] === "=") bi--;
	if (bi < end) b = b.substring(0,bi+1); 
	//replace unsafe chars
	return b.replaceAll("+","-").replaceAll("/","_");
}

//decode url safe base64 into binary string, returns binary string
function DecodeURLBase64(data) {
	//replace unsafe chars
	data = data.replaceAll("-","+").replaceAll("_","/");
	//add padding back
	var pad = data.length%4;
	if (pad) {
		pad = 4-pad;
		for (var i = 0; i < pad; i++) data += "=";
	}
	return atob(data);//decode
}



/**@constructor*/
function Project(i,n) {
	this.id = i;
	this.name = n;
}


/**@constructor*/
function Layer(n,t) {
	this.name = n;
	this.type = t;
	this.glsl = "";
}

Layer.prototype.Delete = function() {}

Layer.prototype.ToJSON = function() {}


/**@constructor
@extends {Layer}*/
function PassLayer(name,glsl) {
	Layer.call(this, name,LAYERTYPE_PASS);
		
	this.glsl = glsl;
	this.resolution = PASSRESOLUTION_DISPLAY;
	this.fixedWidth = 512;
	this.fixedHeight = 512;
	this.width = 1;
	this.height = 1;
	
	this.finalGlsl = "";
	this.lastChanged = 0;
	this.lastCompiled = -1;
	
	this.renderTexture = display;
	this.shader = gl.createShader(gl.FRAGMENT_SHADER);
	this.program = null;
	this.paramsUniform = null;
	this.mouseUniform = null;
	this.keyboardUniform = null;
	this.layerTexUniforms = [];
	this.layerSizeUniforms = [];
	this.lastTexUsage = [];
	
	this.usedNextFrame = false;
	this.hasOwnRT = false;
	this.nextRT = null;
}
PassLayer.prototype = Object.create(Layer.prototype);

PassLayer.prototype.Delete = function() {
	gl.deleteShader(this.shader);
	if (this.program) gl.deleteProgram(this.program);
	if (this.usedNextFrame) {
		this.renderTexture.Delete();
		this.nextRT.Delete();
	}
	passes.splice(passes.indexOf(this),1);
}

PassLayer.prototype.ToJSON = function() {
	return {"n":this.name, "t":this.type, "g":this.glsl, "r":this.resolution, "w":this.fixedWidth,"h":this.fixedHeight};
}



/**@constructor
@extends {Layer}*/
function ImageLayer(name) {
	Layer.call(this, name,LAYERTYPE_IMAGE);
	
	this.image = new Image();
	this.image.className += "LayImg";
	this.width = 0;
	this.height = 0;
	
	this.texture = gl.createTexture();
	this.repeatX = false;
	this.repeatY = false;
	this.linearFiltering = false;
	this.mipMaps = false;
}
ImageLayer.prototype = Object.create(Layer.prototype);

ImageLayer.prototype.Delete = function() {
	gl.deleteTexture(this.texture);
}

ImageLayer.prototype.ToJSON = function() {
	return {"n":this.name, "t":this.type, "g":this.glsl, "x":this.repeatX, "y":this.repeatY, "l":this.linearFiltering,"m":this.mipMaps};
}



/**@constructor
@extends {Layer}*/
function SharedGLSLLayer(name,glsl) {
	Layer.call(this, name,LAYERTYPE_SHAREDGLSL);
	
	this.glsl = glsl;
	this.lastChanged = 0;
}
SharedGLSLLayer.prototype = Object.create(Layer.prototype);

SharedGLSLLayer.prototype.ToJSON = function() {
	return {"n":this.name, "t":this.type, "g":this.glsl};
}


/**@constructor
@extends {Layer}*/
function JSONLayer(name) {
	Layer.call(this, name,LAYERTYPE_JSON);
	
	this.arrayNames = null;
	this.arrays = null;
	this.array = null;
	this.width = 0;
	this.height = 0;
	
	this.texture = gl.createTexture();
	this.channels = 0;
}
JSONLayer.prototype = Object.create(Layer.prototype);

JSONLayer.prototype.Delete = function() {
	gl.deleteTexture(this.texture);
}

JSONLayer.prototype.ToJSON = function() {
	return {"n":this.name, "t":this.type, "g":this.glsl, "c":this.channels};
}





//free data from currently loaded project
function FreeProject() {
	//delete current layers
	for (var i = 0; i < layers.length; i++) layers[i].Delete();
	layers.length = 0;
}

//create new layer from json
function LayerFromJSON(js) {
	var type = js["t"], lay;
	switch (type) {
		case LAYERTYPE_PASS:
			lay = new PassLayer(js["n"], js["g"]);
			lay.resolution = js["r"];
			lay.fixedWidth = js["w"];
			lay.fixedHeight = js["h"];
			break;
		
		case LAYERTYPE_IMAGE:
			lay = new ImageLayer(js["n"]);
			lay.repeatX = js["x"];
			lay.repeatY = js["y"];
			lay.linearFiltering = js["l"];
			lay.mipMaps = js["m"];
			lay.glsl = js["g"];
			break;
			
		case LAYERTYPE_SHAREDGLSL:
			lay = new SharedGLSLLayer(js["n"], js["g"]);
			break;
			
		case LAYERTYPE_JSON:
			lay = new JSONLayer(js["n"]);
			lay.channels = js["c"];
			lay.glsl = js["g"];
			break;
		
	}
	return lay;
}


//serialize current project as json
function ProjectToJSON() {
	var lays = new Array(layers.length);
	for (var i = 0; i < layers.length; i++) lays[i] = layers[i].ToJSON();

	return {"c":projectConfig.GetKeyValues(), "l":lays, "b":buildConfig.GetKeyValues(), "bm":buildModes, "bo":buildOptions, "bc":buildCheckedLayers, "gp":buildGamepadMappings};
}

//deserialize and load project from json
function ProjectFromJSON(pj) {
	//load layers from json
	var lays = pj["l"];
	layers.length = lays.length;
	passes.length = 0;
	for (var i = 0; i < layers.length; i++) {
		var lay = LayerFromJSON(lays[i]);
		layers[i] = lay;
		if (lay.type === LAYERTYPE_PASS) passes.push(lay);
	}
	
	var bjs = pj["b"];
	if (bjs) {
		buildConfig.SetKeyValues(bjs);
		buildModes = pj["bm"];
		buildOptions = pj["bo"];
		buildCheckedLayers = pj["bc"];
		buildGamepadMappings = pj["gp"];

	} else {
		buildModes.length = 0;
		buildOptions.length = 0;
		buildCheckedLayers.length = 0;
	}
	UpdateBuildSelects();

	projectConfig.SetKeyValues(pj["c"]);
	UpdateProjectSettings();
	SetSidebarLayer(0);
}



//save projects list to storage
function SaveProjects() {
	project.name = projectConfig["ProjectName"].value;//ensure current project name is up to date

	var dat = new Array(projects.length);
	for (var i = 0; i < projects.length; i++) {
		var p = projects[i];
		dat[i] = {"i":p.id, "n":p.name};
	}
	IndexedStorage_Store("Projects", JSON.stringify(dat));
}

//save currently loaded project
function SaveProject() {
	//ensure layer glsl matches editor before saving
	if (layer.type === LAYERTYPE_PASS || layer.type === LAYERTYPE_SHAREDGLSL) layer.glsl = glslEditor.text.value;

	IndexedStorage_Store("Project_"+project.id, JSON.stringify(ProjectToJSON()));
}


//get array of all project names
function GetProjectNames() {
	var names = new Array(projects.length);
	for (var i = 0; i < projects.length; i++) names[i] = projects[i].name;
	return names;
}

function LayerIdName(i) {
	return "(Layer"+i+")";
}

//get array of all layer names
function GetLayerNames() {
	var names = new Array(layers.length);
	for (var i = 0; i < layers.length; i++) names[i] = layers[i].name+LayerIdName(i);
	return names;
}


//create new blank project
function CreateNewProject(n) {
	var nextId = 0;
	for (var i = 0; i < projects.length; i++) nextId = Math.max(nextId, projects[i].id);
	
	projects.splice(0,0, project=new Project((nextId+1)%Number.MAX_SAFE_INTEGER,n));
	
}



//main rendering and update loop
function MainLoop() {
	var rendering = (appStatus===APPSTATUS_RENDERING);
	if ((appStatus === APPSTATUS_MAIN && playing) || rendering) {
		currentTime = Date.now();
		var delta = currentTime-lastTime;
	
		if (lockFps === 0) {//realtime framerate, same as browser/monitor
			framerate = 1000/Math.max(1,delta);
			animationTime = (currentTime-animationRefTime)/1000;
			
			RenderBufferPasses();//render
			RenderPass(passes[passes.length-1]);
			SwapBackBuffers();
			if (captureMouse) canvasMouseX = canvasMouseY = 0;
		
		} else {//fixed framerate
			var frameTime = 1000/lockFps, frameTimeSec = frameTime/1000;
			framerate = lockFps;
			animationRefTime += delta;
			
			var moreFrames = animationRefTime>=frameTime;
			while (moreFrames) {
				animationTime += frameTimeSec;
				animationRefTime -= frameTime;
				moreFrames = animationRefTime>=frameTime;
				
				RenderBufferPasses();//render
				if (captureMouse) canvasMouseX = canvasMouseY = 0;
					
				if (moreFrames) {
					SwapBackBuffers();
					
				} else {
					RenderPass(passes[passes.length-1]);
					SwapBackBuffers();
				}
			}
		}
		
		if (rendering) {
			if (animationTime >= renderEndTime) {
				//finished rendering
				FinishRender();
				
			} else {
				//update render progress
				renderProgress.textContent = animationTime.toFixed(2)+" / "+renderEndTime.toFixed(2);
			}
			
		} else {
			sidebarInput["AnimTime"].SetValue(animationTime);
		}
		
		lastTime = currentTime;
	
	} else {
		if (captureMouse) canvasMouseX = canvasMouseY = 0;
	}
	
	requestAnimationFrame(MainLoop);
}
