

//shortcut for getting element by id and adding click event listener
function BEC(id,cb) {
	document.getElementById(id).addEventListener("click",cb);
}

//set element visible
function EV(ele,vis,inlineBlock,inline) {
	ele.style.display = vis?(inlineBlock?(inline?"inline":"inline-block"):"block"):"none";
}

//save file containing data in dataUrl, must be called from event
function SaveFilePrompt(dataUrl,fname) {
	var a = document.createElement("a");
	a.href = dataUrl;
	a.download = fname;
	a.click();
}
//load file prompt hooked to callback, must be called from event like onclick
function LoadFilePrompt(callback,acceptType,multiple) {
	var fi = document.createElement("input");
	fi.type = "file";
	if (acceptType) fi.accept = acceptType;
	if (multiple) fi.multiple = true;
	fi.addEventListener("change",callback);
	fi.click();
}

//initialize select element options
function SetSelectOptions(id,opt,defaultInd) {
	var ele = document.getElementById(id);
	ele.innerHTML = "";
	for (var i = 0; i < opt.length; i++) {
		var oe = document.createElement("option");
		oe.textContent = opt[i];
		ele.appendChild(oe);
	}
	ele.selectedIndex = defaultInd?defaultInd:0;
}


/**@constructor*/
function InputGUIColor() {
	this["r"] = 0;
	this["g"] = 0;
	this["b"] = 0;
}
//parse color hex string
InputGUIColor.prototype.ParseString = function(str) {
	this["r"] = parseInt(str.substring(1,3),16);
	this["g"] = parseInt(str.substring(3,5),16);
	this["b"] = parseInt(str.substring(5,7),16);
}
//to color hex string
InputGUIColor.prototype.ToString = function() {
	var str = "#", t = this["r"].toString(16);
	str += t.length===1?"0"+t:t;
	t = this["g"].toString(16);
	str += t.length===1?"0"+t:t;
	t = this["b"].toString(16);
	return str+(t.length===1?"0"+t:t);
}


var INPUTGUITYPE_TEXT = 0,  INPUTGUITYPE_NUMBER = 1, INPUTGUITYPE_RANGE = 2, INPUTGUITYPE_COLOR = 3, INPUTGUITYPE_CHECKBOX = 4, INPUTGUITYPE_SELECT = 5;

/**@constructor*/
function InputGUIElement(i,ele,gui) {
	this.id = i;
	this.element = ele;
	this.inputGUI = gui;
	var tpid = INPUTGUITYPE_SELECT;
	if (ele.type === "checkbox") tpid = INPUTGUITYPE_CHECKBOX;
	else if (ele.type === "text") tpid = INPUTGUITYPE_TEXT;
	else if (ele.type === "number") tpid = INPUTGUITYPE_NUMBER;
	else if (ele.type === "range") tpid = INPUTGUITYPE_RANGE;
	else if (ele.type === "color") tpid = INPUTGUITYPE_COLOR;
	else if (ele.tagName === "TEXTAREA") tpid = INPUTGUITYPE_TEXT;
	this.type = tpid;
	this.value = ele.type==="color"?new InputGUIColor():null;
	this.changed = false;
}
InputGUIElement.prototype.SetValue = function(v) {
	if (this.type === INPUTGUITYPE_COLOR) {
		Object.assign(this.value,v);
		this.element.value = this.value.ToString();
	} else if (this.type === INPUTGUITYPE_SELECT) {
		this.value = v;
		this.element.selectedIndex = v;
	} else if (this.type === INPUTGUITYPE_CHECKBOX) {
		this.value = v;
		this.element.checked = v;
	} else {
		this.element.value = this.value = v;
	}
}
//initialize select element options
InputGUIElement.prototype.SetSelectOptions = function(opt,defaultInd) {
	var ele = this.element;
	ele.innerHTML = "";
	for (var i = 0; i < opt.length; i++) {
		var oe = document.createElement("option");
		oe.textContent = opt[i];
		ele.appendChild(oe);
	}
	this.SetValue(defaultInd?defaultInd:0);
}



//automatically parses states for input text, checkbox, number, range, color and select elements
/**@constructor*/
function InputGUI(ids,eles) {
	this.elements = new Array(ids.length);
	this.elementsChanged = false;
	
	for (var i = 0; i < ids.length; i++) {
		var ele = eles?eles[i]:document.getElementById(ids[i]),
			obj = new InputGUIElement(i,ele,this);
		this.elements[i] = obj;
		this[ids[i]] = obj;
		ele.inputGUIElement = obj;
		ele.addEventListener(obj.type<=INPUTGUITYPE_COLOR?"input":"change",InputGUI_OnChange);
		InputGUI_OnChange({target:ele});
	}
}
function InputGUI_OnChange(e) {
	var ele = e.target, obj = ele.inputGUIElement, ov = obj.value;
	switch (obj.type) {
		case INPUTGUITYPE_CHECKBOX:
			obj.value = ele.checked;
			break;
		
		case INPUTGUITYPE_TEXT:
			obj.value = ele.value;
			break;
			
		case INPUTGUITYPE_NUMBER:
			var minv = ele.min?ele.min:-Number.MAX_VALUE, maxv = ele.max?ele.max:Number.MAX_VALUE,
				pval = parseFloat(ele.value), step = ele.step;
			if (step && step !== "any") pval = Math.floor(pval/step)*step;
			obj.value = Math.max(minv,Math.min(maxv,isNaN(pval)||!isFinite(pval) ? 0 : pval));
			break;
			
		case INPUTGUITYPE_RANGE:
			obj.value = parseFloat(ele.value);
			break;
			
		case INPUTGUITYPE_COLOR:
			obj.value.ParseString(ele.value);
			break;
		
		case INPUTGUITYPE_SELECT:
			obj.value = parseInt(ele.selectedIndex);
			break;
	}
	if (ov !== obj.value) obj.changed = obj.inputGUI.elementsChanged = true;
}

InputGUI.prototype.GetKeyValues = function() {
	var vals = {};
	for (var i = 0; i < this.elements.length; i++) {
		var ele = this.elements[i];
		vals[ele.element.id] = ele.value;
	}
	return vals;
}
InputGUI.prototype.SetKeyValues = function(vals) {
	for (var k in vals) this[k].SetValue(vals[k]);
}

InputGUI.prototype.GetValues = function() {
	var vals = [];
	for (var i = 0; i < this.elements.length; i++) vals.push(this.elements[i].value);
	return vals;
}
InputGUI.prototype.SetValues = function(vals) {
	for (var i = 0; i < vals.length; i++) this.elements[i].SetValue(vals[i]);
}
