


var canvasMouseX = 0, canvasMouseY = 0, leftMouseDown = 0, rightMouseDown = 0,
keyCodeLUT = {}, keyboardState = new Uint32Array(4),
KEYBOARD_CODES = ["Escape","Digit1","Digit2","Digit3","Digit4","Digit5","Digit6","Digit7","Digit8","Digit9","Digit0","Minus","Equal","Backspace","Tab","KeyQ","KeyW","KeyE","KeyR","KeyT","KeyY","KeyU","KeyI","KeyO","KeyP","BracketLeft","BracketRight","Enter","ControlLeft","KeyA","KeyS","KeyD","KeyF","KeyG","KeyH","KeyJ","KeyK","KeyL","Semicolon","Quote","Backquote","ShiftLeft","Backslash","KeyZ","KeyX","KeyC","KeyV","KeyB","KeyN","KeyM","Comma","Period","Slash","ShiftRight","NumpadMultiply","AltLeft","Space","CapsLock","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","ScrollLock","Numpad7","Numpad8","Numpad9","NumpadSubtract","Numpad4","Numpad5","Numpad6","NumpadAdd","Numpad1","Numpad2","Numpad3","Numpad0","NumpadDecimal","IntlBackslash","F11","F12","NumpadEqual","NumpadComma","NumpadEnter","ControlRight","NumpadDivide","AltRight","NumLock","Home","ArrowUp","PageUp","ArrowLeft","ArrowRight","End","ArrowDown","PageDown","Insert","Delete"];



function InitializeMouseKeyboard() {
	//canvas mouse events
	quickGLCanvas.addEventListener("mousedown", function(e) {
		if (e.button === 0) {
			if (captureMouse) {
				if (document.pointerLockElement !== quickGLCanvas) quickGLCanvas.requestPointerLock({"unadjustedMovement":true});
			}
			leftMouseDown = 1;
			
		} else if (e.button === 2) {
			rightMouseDown = 1;
			e.preventDefault();
		}
	});
	quickGLCanvas.addEventListener("mouseup", function(e) {
		if (e.button === 0) leftMouseDown = 0;
		else if (e.button === 2) {
			rightMouseDown = 0;
			e.preventDefault();
		}
	});
	quickGLCanvas.addEventListener("contextmenu", function(e) {
		e.preventDefault();
	});
	
	quickGLCanvas.addEventListener("mousemove", function(e) {
		if (captureMouse) {
			canvasMouseX += e.movementX*pixelScaling;
			canvasMouseY += e.movementY*-pixelScaling;
			
		} else {
			canvasMouseX = Math.floor((document.fullscreenElement === quickGLCanvas ? e.clientX : e.clientX-window.innerWidth*0.3)*pixelScaling);
			canvasMouseY = Math.floor(display.height-1-e.clientY*pixelScaling);
		}
	});
	
	
	//canvas keyboard events
	for (var i = 0; i < KEYBOARD_CODES.length; i++) keyCodeLUT[KEYBOARD_CODES[i]] = i;
	
	quickGLCanvas.addEventListener("keydown", function(e) {
		if (e.key === playHotkey) return;
	
		var id = keyCodeLUT[e.code];
		if (id !== undefined) {
			var aid = Math.floor(id/32), bit = id%32;
			keyboardState[aid] |= 1<<bit;
			e.preventDefault();
			e.stopPropagation();
		}
	});
	
	quickGLCanvas.addEventListener("keyup", function(e) {
		if (e.key === playHotkey) return;
	
		var id = keyCodeLUT[e.code];
		if (id !== undefined) {
			var aid = Math.floor(id/32), bit = id%32;
			keyboardState[aid] &= ~(1<<bit);
			e.preventDefault();
			e.stopPropagation();
		}
	});
}


/*snippet to print keycode names for about list

var str = "";
for (var i = 0; i < KEYBOARD_CODES.length; i++) {
	if (i) str += ", ";
	str += KEYBOARD_CODES[i].replaceAll("Key","").replaceAll("Digit","").toUpperCase();
}
console.log(str);
*/


/*snippet to grab key codes from mozilla docs

(function() {
var rows = temp0.childNodes,
	skip = 1, lastCode = "Delete",
	ignore = {"Unidentified":1, "PrintScreen":1, "F13":1,"F14":1,"F15":1,"F16":1,"F17":1,"F18":1,"F19":1,"F20":1,"F21":1,"F22":1,"F23":1,"F24":1,"F25":1,
			"KanaMode":1,"Lang1":1,"Lang2":1,"IntlRo":1,"Convert":1,"NonConvert":1,"IntlYen":1, "MediaTrackPrevious":1,"MediaTrackNext":1,"AudioVolumeMute":1,"LaunchApp2":1,
			"Pause":1,"MediaPlayPause":1,"MediaStop":1,"VolumeDown":1,"VolumeUp":1,"BrowserHome":1,"PrintScreen":1,"OSLeft":1,"OSRight":1,"ContextMenu":1,"Power":1},
	keyCodes = [];
for (var r = 0; r < rows.length; r++) {
	var ele = rows[r];
	if (ele.tagName && ele.tagName === "TR") {
		var col = ele.childNodes, code = null;
		for (var c = 0; c < col.length; c++) {
			var cele = col[c];
			if (cele.tagName && cele.tagName === "TD") {
				code = cele.textContent;
				break;
			}
		}
		if (!code) continue;
	
		code = code.substring(1, code.indexOf('"',1));
		if (code.length === 0 || ignore[code]) continue;
		
		if (skip) {
			skip--;
			continue;
		}
	
		keyCodes.push(code);
		if (code === lastCode) break;
	}
}
console.log(JSON.stringify(keyCodes));
}());
*/

