
//TODO: -save/load state buttons

var launched = false, playing = false, renderEndTime = 0, renderImageURL = null, playHotkey, captureMouse = false,
lockFps = 0, animationTime = 0, animationRefTime = 0, lastTime = 0, currentTime = 0, framerate = 0,
project = null, layers = [], passes = [], stillLoadingImages = 0,
buildConfig, buildModes = [], buildOptions = [], buildSaveLayers = [], bgAudio = null,
buildGamepadMappings = null,
launchPanel, pausePanel, mainPanel,
mouseSensi = 0, currentMode = -1, saveStateURL = null, loadingState = null,
modeSelect, launchVolume, launchSensi, pauseVolume, pauseSensi, lastSettings = null,

LAYERTYPE_PASS = 0, LAYERTYPE_SHAREDGLSL = 1, LAYERTYPE_IMAGE = 2, LAYERTYPE_JSON = 3,
PASSRESOLUTION_DISPLAY = 0, PASSRESOLUTION_FIXED = 1;



//DOM loaded, program entry point
document.addEventListener("DOMContentLoaded",function() {

	if (!InitializeGraphics()) return;	
	InitializeMouseKeyboard();

	mainPanel = document.getElementById("MainPanel");	
	launchPanel = document.getElementById("LaunchPanel");
	pausePanel = document.getElementById("PausePanel");
	
	//load project json from element
	var projEle = document.getElementById("GCPJS");
	if (projEle) {
		var pjs = null;
		try {
			pjs = JSON.parse(projEle.textContent);
		} catch(e) {}
		
		if (pjs) {
			ProjectFromJSON(pjs);
			
			//load any embedded images/json
			var loadedImgs = false;
			for (var i = 0; i < layers.length; i++) {
				var lay = layers[i];
				if (lay.type >= LAYERTYPE_IMAGE) {
					var dat = document.getElementById("LAYER"+i);
					if (dat) {
						if (lay.type === LAYERTYPE_IMAGE) {
							stillLoadingImages++;
							lay.image.glslCanvasLayer = lay;
							lay.image.onload = OnImageLoad;
							lay.image.src = dat.textContent;
							loadedImgs = true;
							
						} else {
							var ljs = null;
							try {
								ljs = JSON.parse(DecodeURLBase64(dat.textContent));
							} catch(e) {}
							if (ljs) LoadJSONArray(lay, ljs);
						}
					}
					
				}
			}
			
			//load last settings
			IndexedStorage_Open("GLSLCanvasStandalone", function() {
				IndexedStorage_Load(project["ProjectName"].replaceAll(" ","_"), function(id,data) {
					if (data) lastSettings = JSON.parse(data);
					
					if (loadedImgs) CheckImagesLoaded();
					else ExitSplash();
				});
			});
		}
	}
});


//string replace all polyfill
if (!String.prototype.replaceAll) {
	String.prototype.replaceAll = function(key,rep) {
		var o = "", i = 0;
		while (true) {
			var n = this.indexOf(key, i);
			if (n === -1) {
				o += this.substring(i,this.length);
				break;
			}
			o += this.substring(i, n)+rep;
			i = n+key.length;
		}
		return o;
	}
}


//display full screen crash message
function FatalCrash(msg) {
	document.body.innerHTML = "<div class='FatalCrash'>"+msg+"</div>";
}


//decode url safe base64 into binary string, returns binary string
function DecodeURLBase64(data) {
	//replace unsafe chars
	data = data.replaceAll("-","+").replaceAll("_","/");
	//add padding back
	var pad = data.length%4;
	if (pad) {
		pad = 4-pad;
		for (var i = 0; i < pad; i++) data += "=";
	}
	return atob(data);//decode
}

//save file containing data in dataUrl, must be called from event
function SaveFilePrompt(dataUrl,fname) {
	var a = document.createElement("a");
	a.href = dataUrl;
	a.download = fname;
	a.click();
}
//load file prompt hooked to callback, must be called from event like onclick
function LoadFilePrompt(callback,acceptType,multiple) {
	var fi = document.createElement("input");
	fi.type = "file";
	if (acceptType) fi.accept = acceptType;
	if (multiple) fi.multiple = true;
	fi.addEventListener("change",callback);
	fi.click();
}


//load save state from file
function OnLoadState(e) {
	var f = e.target.files;
	if (f && f.length) {
		var fr = new FileReader();
		fr.onload = OnLoadStateFile;
		fr.readAsArrayBuffer(f[0]);
	}
}

function OnLoadStateFile(e) {
	if (launched) return;

	var buf = new Float32Array(e.target.result);
	if (buildModes.length > 1) modeSelect.selectedIndex = (new Uint32Array(buf.buffer))[0];
	
	for (var i = 0; i < buildOptions.length; i++) buildOptions[i].element.value = buf[2+i];
	
	loadingState = buf;
	Launch();
}


//save settings
function SaveSettings() {
	var vals = {};
	if (captureMouse) vals["s"] = mouseSensi;
	if (bgAudio) vals["v"] = bgAudio.volume;
	
	for (var i = 0; i < buildOptions.length; i++) {
		var opt = buildOptions[i];
		vals["o"+opt.name] = opt.element.value;
	}
	
	IndexedStorage_Store(project["ProjectName"].replaceAll(" ","_"), JSON.stringify(vals));
}


//compile passes
function CompilePasses() {
	//generate shared glsl
	var sharedGlsl = "";
	
	if (buildModes.length > 1) {
		currentMode = Math.max(0,modeSelect.selectedIndex);
		sharedGlsl += "#define BUILD_MODE_ID "+currentMode+"\n";
	}
	
	for (var i = 0; i < buildOptions.length; i++) {
		var opt = buildOptions[i],
			val = Math.round(opt.element.value);
		sharedGlsl += "#define "+opt.name.toUpperCase().replaceAll(" ","_").replaceAll("-","_").replaceAll(",","_")+" "+val+"\n";
	}
	
	for (var i = 0; i < layers.length; i++) {
		var l = layers[i];
		if (l.type === LAYERTYPE_SHAREDGLSL) {
			sharedGlsl += l.glsl+"\n\n";
		}
	}

	//compile pass layers
	for (var i = 0; i < layers.length; i++) {
		var l = layers[i];
		if (l.type === LAYERTYPE_PASS) {
			l.finalGlsl = fragShaderHead+sharedGlsl+l.glsl;
			if (!RecompilePassLayer(i,l)) return false;
		}
	}

	//recompute rendertexture dependancy graph
	ComputePassDependencies();

	//load pass layer state if launching from save state
	if (loadingState) {
		var bufi = 2+buildOptions.length;
		animationTime = loadingState[1];
		
		for (var i = 0; i < buildSaveLayers.length; i++) {
			var lay = layers[buildSaveLayers[i]], lsz = lay.fixedWidth*lay.fixedHeight*4;
			if (lay.renderTexture) {
				var dat = loadingState.subarray(bufi,bufi+lsz);
				lay.renderTexture.SetSize(lay.fixedWidth,lay.fixedHeight, dat);
				if (lay.nextRT) lay.nextRT.SetSize(lay.fixedWidth,lay.fixedHeight, dat);
			}
			bufi += lsz;
		}
		
		loadingState = null;
	}
	
	return true;
}


//play/pause
function Play(play) {
	playing = play;
	if (playing) {
		//initialize frame timer
		if (buildConfig["BuildPause"]) {
			//hide pause menu
			pausePanel.style.display = "none";
			mainPanel.style.display = "block";
			if (captureMouse) {
				mouseSensi = pauseSensi.value;
				UpdateSensi();
			}
			
			SaveSettings();
		}
		
		PlayAudio(currentMode); 
		
		if (lockFps === 0) {
			animationRefTime = Date.now()-animationTime*1000;
		} else {
			animationRefTime = 0;
		}
		
		lastTime = Date.now();
		
	} else {
		if (buildConfig["BuildPause"]) {
			//show pause menu
			mainPanel.style.display = "none";
			pausePanel.style.display = "block";
			
			//copy volume/sens from launch
			if (captureMouse) pauseSensi.value = mouseSensi;
			if (bgAudio) pauseVolume.value = launchVolume.value;
		
			//break pointer lock
			if (captureMouse) document.exitPointerLock();
		}
		PlayAudio(-1);
	}
}


function CheckImagesLoaded() {
	if (stillLoadingImages) setTimeout(CheckImagesLoaded,20);
	else ExitSplash();
}

function ExitSplash() {
	if (buildConfig["BuildLaunch"]) {
		//init launch menu
		var lc = document.getElementById("LaunchContent");
		lc.innerHTML = "<span class='Tit'>"+project["ProjectName"]+"</span></br>"+buildConfig["BuildLaunchText"]+"</br>";
		
		if (buildModes.length > 1) lc.appendChild(modeSelect);
		
		for (var i = 0; i < buildOptions.length; i++) {
			var opt = buildOptions[i];
			lc.appendChild(document.createElement("br"));
			lc.appendChild(LabelInput(opt.element,opt.name));
			if (lastSettings) {
				var ov = lastSettings["o"+opt.name];
				if (ov !== undefined) opt.element.value = ov;
			}
		}
		
		if (captureMouse) {
			launchSensi = NewInputElement(true,"-3","3", lastSettings ? lastSettings["s"] : 0);
			lc.appendChild(document.createElement("br"));
			lc.appendChild(LabelInput(launchSensi, "Mouse Sensitivity"));
		}
		if (bgAudio) {
			launchVolume = NewInputElement(true,"0","1", lastSettings ? lastSettings["v"] : 0.5);
			launchVolume.addEventListener("input", function() {bgAudio.volume = parseFloat(launchVolume.value);});
			lc.appendChild(document.createElement("br"));
			lc.appendChild(LabelInput(launchVolume, "Audio Volume"));
		}
		
		launchPanel.style.display = "block";
		
		document.getElementById("Launch").addEventListener("click", Launch);
		
	} else {
		//no menu go straight into playing
		if (!CompilePasses()) return;	
		mainPanel.style.display = "block";
		Play(true);
		launched = true;
	}
	
	document.getElementById("SplashPanel").style.display = "none";
	MainLoop();
}

function Launch() {
	animationTime = 0;
	if (!CompilePasses()) return;
			
	launchPanel.style.display = "none";
	mainPanel.style.display = "block";

	Play(true);
	if (captureMouse) {
		mouseSensi = launchSensi.value;
		UpdateSensi();
		CaptureMouse();
	}
	
	SaveSettings();
	
	launched = true;
}


function NewInputElement(slider,min,max,def) {
	var ele = document.createElement("input");
	if (slider) {
		ele.type = "range";
	} else {
		ele.size = "10";
		ele.type = "number";
	}
	if (min.length > 0 && max.length > 0) {
		ele.min = min;
		ele.max = max;
	}
	ele.step = "any";
	ele.value = def;
	return ele;
}
function LabelInput(iele, txt) {
	var lbl = document.createElement("label");
	lbl.innerText = txt+" ";
	lbl.appendChild(iele);
	return lbl;
}




function UpdateSensi() {
	mouseSensitivity = Math.pow(10,parseFloat(mouseSensi));
}


function PlayAudio(mode) {
	if (!bgAudio) return;
	
	var src = buildConfig["BuildAudio"];
	if (mode > -1) {
		var ma = buildModes[mode].audio;
		if (ma.length > 0) src = ma;
	}
	
	if (src.length > 0) {
		if (src !== bgAudio.src) bgAudio.src = src;
		bgAudio.play();
	} else {
		bgAudio.pause();
	}
}



/**@constructor*/
function Layer(n,t) {
	this.name = n;
	this.type = t;
	this.glsl = "";
}

Layer.prototype.Delete = function() {}




/**@constructor
@extends {Layer}*/
function PassLayer(name,glsl) {
	Layer.call(this, name,LAYERTYPE_PASS);
		
	this.glsl = glsl;
	this.resolution = PASSRESOLUTION_DISPLAY;
	this.fixedWidth = 512;
	this.fixedHeight = 512;
	this.width = 1;
	this.height = 1;
	
	this.finalGlsl = "";
	this.lastChanged = 0;
	this.lastCompiled = -1;
	
	this.renderTexture = display;
	this.shader = gl.createShader(gl.FRAGMENT_SHADER);
	this.program = null;
	this.paramsUniform = null;
	this.mouseUniform = null;
	this.keyboardUniform = null;
	this.layerTexUniforms = [];
	this.layerSizeUniforms = [];
	this.lastTexUsage = [];
	
	this.usedNextFrame = false;
	this.hasOwnRT = false;
	this.nextRT = null;
}
PassLayer.prototype = Object.create(Layer.prototype);

PassLayer.prototype.Delete = function() {
	gl.deleteShader(this.shader);
	if (this.program) gl.deleteProgram(this.program);
	if (this.usedNextFrame) {
		this.renderTexture.Delete();
		this.nextRT.Delete();
	}
	passes.splice(passes.indexOf(this),1);
}



/**@constructor
@extends {Layer}*/
function ImageLayer(name) {
	Layer.call(this, name,LAYERTYPE_IMAGE);
	
	this.image = new Image();
	this.image.className += "LayImg";
	this.width = 1;
	this.height = 1;
	
	this.texture = gl.createTexture();
	this.repeatX = false;
	this.repeatY = false;
	this.linearFiltering = false;
	this.mipMaps = false;
}
ImageLayer.prototype = Object.create(Layer.prototype);

ImageLayer.prototype.Delete = function() {
	gl.deleteTexture(this.texture);
}




/**@constructor
@extends {Layer}*/
function SharedGLSLLayer(name,glsl) {
	Layer.call(this, name,LAYERTYPE_SHAREDGLSL);
	
	this.glsl = glsl;
	this.lastChanged = 0;
}
SharedGLSLLayer.prototype = Object.create(Layer.prototype);



/**@constructor
@extends {Layer}*/
function JSONLayer(name) {
	Layer.call(this, name,LAYERTYPE_JSON);
	
	this.arrayNames = null;
	this.arrays = null;
	this.array = null;
	this.width = 0;
	this.height = 0;
	
	this.texture = gl.createTexture();
	this.channels = 0;
}
JSONLayer.prototype = Object.create(Layer.prototype);

JSONLayer.prototype.Delete = function() {
	gl.deleteTexture(this.texture);
}



/**@constructor*/
function BuildMode(js) {
	this.name = js["n"];
	this.audio = js["a"];
}

/**@constructor*/    
function BuildOption(js) {
	this.name = js["n"];
	this.slider = js["s"];
	this.min = js["m"];
	this.max = js["u"];
	this.default = js["d"];
	
	this.element = NewInputElement(this.slider,this.min,this.max,this.default);
}





//create new layer from json
function LayerFromJSON(js) {
	var type = js["t"], lay;
	switch (type) {
		case LAYERTYPE_PASS:
			lay = new PassLayer(js["n"], js["g"]);
			lay.resolution = js["r"];
			lay.fixedWidth = js["w"];
			lay.fixedHeight = js["h"];
			break;
		
		case LAYERTYPE_IMAGE:
			lay = new ImageLayer(js["n"]);
			lay.repeatX = js["x"];
			lay.repeatY = js["y"];
			lay.linearFiltering = js["l"];
			lay.mipMaps = js["m"];
			lay.glsl = js["g"];
			break;
			
		case LAYERTYPE_SHAREDGLSL:
			lay = new SharedGLSLLayer(js["n"], js["g"]);
			break;
			
		case LAYERTYPE_JSON:
			lay = new JSONLayer(js["n"]);
			lay.channels = js["c"];
			lay.glsl = js["g"];
			break;
		
	}
	return lay;
}

//deserialize and load project from json
function ProjectFromJSON(pj) {
	//load layers from json
	var lays = pj["l"];
	layers.length = lays.length;
	passes.length = 0;
	for (var i = 0; i < layers.length; i++) {
		var lay = LayerFromJSON(lays[i]);
		layers[i] = lay;
		if (lay.type === LAYERTYPE_PASS) passes.push(lay);
	}
	
	project = pj["c"];
	lockFps = project["LockFPS"];
	playHotkey = project["PlayHotkey"];
	captureMouse = project["CaptureMouse"];
	
	
	buildConfig = pj["b"];
	buildConfig["BuildLaunchText"] = DecodeURLBase64(buildConfig["BuildLaunchText"]);
	buildConfig["BuildPauseText"] = DecodeURLBase64(buildConfig["BuildPauseText"]);
	buildModes = pj["bm"];
	buildOptions = pj["bo"];
	buildSaveLayers = pj["bc"];
	buildGamepadMappings = pj["gp"];
	
	if (buildConfig["GamepadMouse"] || buildGamepadMappings) InitGamepadEvents();

	var hasAudio = buildConfig["BuildAudio"].length>0,
		modes = pj["bm"];
	modeSelect = document.createElement("select");
	buildModes.length = modes.length;
	
	for (var i = 0; i < modes.length; i++) {
		var mode = buildModes[i] = new BuildMode(modes[i]),
			opt = document.createElement("option");
		if (mode.audio.length > 0) hasAudio = true;
		opt.innerText = mode.name;
		modeSelect.appendChild(opt);
	}
	
	if (hasAudio) {
		bgAudio = new Audio();
		bgAudio.loop = true;
	}
	
	var options = pj["bo"];
	buildOptions.length = options.length;
	for (var i = 0; i < options.length; i++) buildOptions[i] = new BuildOption(options[i]);
	
	var saveBtn = document.getElementById("Save"), loadBtn = document.getElementById("Load");
	if (buildConfig["BuildSaveLoad"]) {
		saveBtn.addEventListener("click", function() {
			//save state
			var tsz = 2+buildOptions.length;
			for (var i = 0; i < buildSaveLayers.length; i++) {
				var lay = layers[buildSaveLayers[i]];
				tsz += lay.fixedWidth*lay.fixedHeight*4;
			}
			
			var buf = new Float32Array(tsz), bufi = 2;
			(new Uint32Array(buf.buffer))[0] = currentMode;
			buf[1] = animationTime;
			for (var i = 0; i < buildOptions.length; i++) buf[bufi++] = parseFloat(buildOptions[i].element.value);
			
			for (var i = 0; i < buildSaveLayers.length; i++) {
				var lay = layers[buildSaveLayers[i]];
				if (lay.renderTexture) {
					lay.renderTexture.Bind();
					gl.readPixels(0,0,lay.fixedWidth,lay.fixedHeight,gl.RGBA,gl.FLOAT,buf,bufi);
				}
				bufi += lay.fixedWidth*lay.fixedHeight*4;
			}
			
			if (saveStateURL) URL.revokeObjectURL(saveStateURL);
			saveStateURL = URL.createObjectURL(new Blob([buf]));
			
			var date = new Date(),
				dstr = date.getFullYear()+"_"+(date.getMonth()+1)+"_"+date.getDate()+"_"+(Math.floor(date.getTime()/1000)%(24*60*60));
			SaveFilePrompt(saveStateURL, project["ProjectName"].replaceAll(" ","_")+dstr+".savestate");
		});
		
		loadBtn.addEventListener("click", function() {
			//load state
			LoadFilePrompt(OnLoadState, ".savestate");
		});
		
	} else {
		saveBtn.style.display = loadBtn.style.display = "none";
	}
	
	var hasLaunch = buildConfig["BuildLaunch"],
		hasPause = buildConfig["BuildPause"];
	if (hasLaunch || hasPause) {
		var css = document.createElement("style"),
			customCss = buildConfig["BuildCSS"];
		if (customCss && customCss.length > 2) {
			css.innerHTML = customCss;
			
		} else {
			var fgc = buildConfig["BuildFGColor"],
				bgc = buildConfig["BuildBGColor"];
				
var MXCOL = function(iam) {
	var am = 1-iam, str = "#",
		t = Math.min(255,Math.floor(fgc["r"]*am+bgc["r"]*iam)).toString(16);
	str += t.length===1?"0"+t:t;
	t = Math.min(255,Math.floor(fgc["g"]*am+bgc["g"]*iam)).toString(16);
	str += t.length===1?"0"+t:t;
	t = Math.min(255,Math.floor(fgc["b"]*am+bgc["b"]*iam)).toString(16);
	return str+(t.length===1?"0"+t:t);
}
		
			var thumb = "{background-color:"+MXCOL(0.1)+";border: 0.25vw solid "+MXCOL(0.25)+";}";
			
			css.innerHTML = "div.Panel {color:"+MXCOL(0)+"; background-color:"+MXCOL(1)+";}"+
		
	"span.Tit {color:"+MXCOL(0.5)+"; text-shadow: 0px 0px 0.4vw "+MXCOL(0)+";}"+

	"span.Btn {color:"+MXCOL(0.1)+";background-color:"+MXCOL(0.8)+";border: 0.3vw solid "+MXCOL(0.6)+";}"+

	"span.Btn:hover {background-color:"+MXCOL(0.5)+";}"+

	"input, select {color:"+MXCOL(0.05)+";background-color:"+MXCOL(0.92)+";border: 0.1vw solid "+MXCOL(0.4)+";}"+

	"input[type='range']::-webkit-slider-thumb "+thumb+

	"input[type='range']::-moz-range-thumb "+thumb;
		}

		document.head.appendChild(css);
	}

	if (hasPause) {
		var pc = document.getElementById("PauseContent");
		pc.innerHTML = "<span class='Tit'>"+project["ProjectName"]+" Paused</span></br>"+buildConfig["BuildPauseText"];
		
		document.getElementById("Resume").addEventListener("click", function() {
			Play(true);
		});
		
		document.getElementById("GoFullscreen").addEventListener("click", function() {
			if (document.fullscreenElement) document.exitFullscreen();
			else document.body.requestFullscreen();
		});
		
		var quitBtn = document.getElementById("Quit");
		if (hasLaunch) {
			quitBtn.addEventListener("click", function() {
				launched = false;
				playing = false;
			
				//copy settings from pause menu to launch menu
				if (captureMouse) launchSensi.value = mouseSensi = pauseSensi.value;
				if (bgAudio) launchVolume.value = pauseVolume.value;
				
				mainPanel.style.display = pausePanel.style.display = "none";
				launchPanel.style.display = "block";
			});
		} else {
			quitBtn.style.display = "none";
		}
		
		if (captureMouse) {
			pauseSensi = NewInputElement(true,"-3","3","0");
			pc.appendChild(document.createElement("br"));
			pc.appendChild(LabelInput(pauseSensi, "Mouse Sensitivity"));
		}
		if (bgAudio) {
			pauseVolume = NewInputElement(true,"0","1","0.5");
			pauseVolume.addEventListener("input", function() {bgAudio.volume = parseFloat(pauseVolume.value);});
			pc.appendChild(document.createElement("br"));
			pc.appendChild(LabelInput(pauseVolume, "Audio Volume"));
		}
	}
}



//main rendering and update loop
function MainLoop() {
	if (launched && playing) {
		currentTime = Date.now();
		var delta = currentTime-lastTime;
		
		UpdateGamepad(delta);
	
		if (lockFps === 0) {//realtime framerate, same as browser/monitor
			framerate = 1000/Math.max(1,delta);
			animationTime = (currentTime-animationRefTime)/1000;
			
			RenderBufferPasses();//render
			RenderPass(passes[passes.length-1]);
			SwapBackBuffers();
			if (captureMouse) canvasMouseX = canvasMouseY = 0;
		
		} else {//fixed framerate
			var frameTime = 1000/lockFps, frameTimeSec = frameTime/1000;
			framerate = lockFps;
			animationRefTime += delta;
			
			var moreFrames = animationRefTime>=frameTime;
			while (moreFrames) {
				animationTime += frameTimeSec;
				animationRefTime -= frameTime;
				moreFrames = animationRefTime>=frameTime;
				
				RenderBufferPasses();//render
				if (captureMouse) canvasMouseX = canvasMouseY = 0;
				
				if (moreFrames) {
					SwapBackBuffers();
					
				} else {
					RenderPass(passes[passes.length-1]);
					SwapBackBuffers();
				}
			}
		}

		lastTime = currentTime;
		
	} else {
		if (captureMouse) canvasMouseX = canvasMouseY = 0;
	}
	
	requestAnimationFrame(MainLoop);
}
