
var pixelScaling = 1, floatRtSupport = false, maxTextureSize = 4, displayResized = false,
vertShader, fragShaderHead, fragHeaderLines,
foundPassArray = [], passTextures = [], passTexturesOld = [], unusedPassTextures = [];


function InitializeGraphics() {
	//initialize webgl 2
	if (!InitializeQuickWebGL(document.getElementsByTagName("canvas")[0])) {
		FatalCrash("Fatal Error: Your browser does not support WebGL 2. Try again on a modern browser such as Firefox or Chrome and with a device capable of at least OpenGL ES 3.0 or Core 3.2.");
		return false;
	}
	floatRtSupport = gl.getExtension("EXT_color_buffer_float") ? true : false;
	maxTextureSize = gl.getParameter(gl.MAX_TEXTURE_SIZE);
	
	gl.enable(gl.CULL_FACE);
	gl.cullFace(gl.BACK);
	gl.disable(gl.DEPTH_TEST);
	gl.depthMask(false);
	gl.clearDepth(1.0);
	gl.disable(gl.STENCIL_TEST);
	gl.disable(gl.BLEND);
	gl.enable(gl.SCISSOR_TEST);
	gl.colorMask(true,true,true,true);
	
	
	//vertex shader used by all shader programs
	vertShader = CompileShader(
"#version 300 es\nprecision highp float;precision highp int;"+

"in vec2 vertexPosition;"+
"out vec4 pixelPosition;"+
"uniform vec4 GlslPassParams;"+

"void main() {"+
"	pixelPosition = vec4(vertexPosition, vertexPosition*.5+.5);"+
"	gl_Position = vec4(vertexPosition,1,1);"+
"}",
gl.VERTEX_SHADER);

	//header used by all frag shaders
	fragShaderHead =
"#version 300 es\nprecision highp float;precision highp int;\n\n"+

"in vec4 pixelPosition;\n\n"+

"uniform vec4 GlslPassParams;\n"+
"#define RESOLUTION (GlslPassParams.xy)\n"+
"#define TIME (GlslPassParams.z)\n"+
"#define FRAMERATE (GlslPassParams.w)\n\n"+

"uniform vec4 MouseState;\n"+
"#define MOUSE_POSITION (MouseState.xy)\n"+
"#define MOUSE_LEFT bool(MouseState.z)\n"+
"#define MOUSE_RIGHT bool(MouseState.w)\n\n"+

"uniform uvec4 KeyboardState;\n";
	for (var i = 0; i < KEYBOARD_CODES.length; i++) {
		var n = KEYBOARD_CODES[i].replaceAll("Key","").replaceAll("Digit","").toUpperCase(),
			aid = Math.floor(i/32), bit = i%32;
		fragShaderHead += "#define KEY_"+n+" bool((KeyboardState["+aid+"]" + (bit ? ">>"+bit : "") + ")&1u)\n";
	}
	
	fragShaderHead += "\nout vec4 pixelColor;\n\n";
	
	fragHeaderLines = 121;
	/*var l = 0;
	for (var i = 0; i < fragShaderHead.length; i++) {
		if (fragShaderHead[i] === "\n") l++;
	}
	console.log(l);*/
	
	
	//window resize event
	window.addEventListener("resize",OnWindowResize);
	OnWindowResize();
	
	BindMesh(fullscreenTriangle);
	
	return true;
}


//resize canvas on window resize
function OnWindowResize() {
	//handle dpi scaling
	var ndpi = window.devicePixelRatio;
	if (!ndpi) ndpi = 1;

	//compute canvas size
	quickGLCanvas.width = display.width = Math.ceil(window.innerWidth*ndpi);
	quickGLCanvas.height = display.height = Math.ceil(window.innerHeight*ndpi);
	if (ndpi === 1) {
		if (pixelScaling !== 1) {
			quickGLCanvas.style.removeProperty("width");
			quickGLCanvas.style.removeProperty("height");
		}
	} else {
		quickGLCanvas.style.width = Math.ceil(window.innerWidth)+"px";
		quickGLCanvas.style.height = window.innerHeight+"px";
	}
	pixelScaling = ndpi;
	
	//recompute pass layer sizes
	ComputePassDependencies();
}


//layer uniform data
/**@constructor*/
function LayerUniform(uni,lid) {
	this.uniform = uni;
	this.layerId = lid;
}


//parse opengl shader info log and display in window
function DisplayGLSLErrors(layer, errText) {
	FatalCrash("Error: Shader error '"+layer.name+"': "+errText);
}


//recompile pass layer shader program
function RecompilePassLayer(id,l) {
	if (l.program) gl.deleteProgram(l.program);
	
	//compile fragment shader
	gl.shaderSource(l.shader, l.finalGlsl);
	gl.compileShader(l.shader);
	if (!gl.getShaderParameter(l.shader, gl.COMPILE_STATUS)) {
		DisplayGLSLErrors(l, gl.getShaderInfoLog(l.shader));
		return false;
	}
	
	//link program
	l.program = gl.createProgram();
	gl.attachShader(l.program, vertShader);
	gl.attachShader(l.program, l.shader);
	gl.bindAttribLocation(l.program,0,"vertexPosition");
	gl.linkProgram(l.program);
	if (!gl.getProgramParameter(l.program,gl.LINK_STATUS)) {
		DisplayGLSLErrors(l, gl.getProgramInfoLog(l.program));
		return false;
	}
	
	//get uniforms
	l.paramsUniform = gl.getUniformLocation(l.program,"GlslPassParams");
	l.mouseUniform = gl.getUniformLocation(l.program,"MouseState");
	l.keyboardUniform = gl.getUniformLocation(l.program,"KeyboardState");
	
	var lastPass = passes[passes.length-1];
	l.layerTexUniforms.length = 0;
	l.layerSizeUniforms.length = 0;
	for (var i = 0; i < layers.length; i++) {
		if (layers[i] !== lastPass) {
			var uni = gl.getUniformLocation(l.program,"Layer"+i);
			if (uni) l.layerTexUniforms.push(new LayerUniform(uni,i));
		
			uni = gl.getUniformLocation(l.program,"LayerSize"+i);
			if (uni) l.layerSizeUniforms.push(new LayerUniform(uni,i));
		}
	}
	
	return true;
}


//upload image to texture
function OnImageLoad(e) {
	//update image layer texture
	var layer = e.target.glslCanvasLayer;
	layer.width = layer.image.naturalWidth;
	layer.height = layer.image.naturalHeight;
	
	gl.bindTexture(gl.TEXTURE_2D, layer.texture);
	SetTextureOptions(layer.linearFiltering, layer.mipMaps, layer.repeatX, layer.repeatY);
	gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA,gl.RGBA,gl.UNSIGNED_BYTE, layer.image);
	if (layer.mipMaps) gl.generateMipmap(gl.TEXTURE_2D);
	
	stillLoadingImages--;
}


function LoadJSONArray(layer, array) {	
	//find width*height = array.length while keeping below max texture size
	var chc = layer.channels+1,
		size = array.length, dsize = Math.ceil(size/chc),
		width = dsize, height = 1;
	if (width > maxTextureSize*maxTextureSize) return;
	
	if (width > maxTextureSize) {
		var i, end = Math.min(maxTextureSize+1, Math.ceil(dsize/2));
		for (i = Math.max(2,Math.floor(dsize/maxTextureSize)); i < end; i++) {
			if (dsize%i === 0) {
				width = i;
				height = dsize/i;
				break;
			}
		}
		if (i >= end) width = height = Math.ceil(Math.sqrt(dsize));
	}
	dsize = width*height*chc;
	layer.width = width;
	layer.height = height;
	
	//upload data to texture
	var dat = new Float32Array(width*height*4), di = 0, i;
	switch (chc) {
		case 1://grayscale
			for (i = 0; i < dsize; i++) {
				var v = array[i];
				if (isNaN(v)) v = 0;
				dat[di++] = v; dat[di++] = v; dat[di++] = v;
				dat[di++] = 1;
			}
			break;
			
		case 2://rg
			for (i = 0; i < dsize; i++) {
				var r = array[i++], g = array[i];
				dat[di++] = (isNaN(r) ? 0 : r);
				dat[di++] = (isNaN(g) ? 0 : g);
				dat[di++] = 0;
				dat[di++] = 1;
			}
			break;
			
		case 3://rgb
			for (i = 0; i < dsize; i++) {
				var r = array[i++], g = array[i++], b = array[i];
				dat[di++] = (isNaN(r) ? 0 : r);
				dat[di++] = (isNaN(g) ? 0 : g);
				dat[di++] = (isNaN(b) ? 0 : b);
				dat[di++] = 1;
			}
			break;
			
		case 4://rga
			for (i = 0; i < dsize; i++) {
				var r = array[i++], g = array[i++], b = array[i++], a = array[i++];
				dat[di++] = (isNaN(r) ? 0 : r);
				dat[di++] = (isNaN(g) ? 0 : g);
				dat[di++] = (isNaN(b) ? 0 : b);
				dat[di++] = (isNaN(a) ? 0 : a);
			}
			break;
	}
	
	gl.bindTexture(gl.TEXTURE_2D, layer.texture);
	SetTextureOptions(false,false,false,false);
	gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA32F, width,height, 0,gl.RGBA,gl.FLOAT, dat);
}


//create new rendertexture
function CreateRT(w,h) {
	return floatRtSupport ? new RenderTexture(w,h,gl.RGBA32F,gl.RGBA,gl.FLOAT) :
							new RenderTexture(w,h,gl.RGBA,gl.RGBA,gl.UNSIGNED_BYTE);
}


//compute required rendertextures for passes
function ComputePassDependencies() {
	if (!project) return;

	//reset last state and compute pass width/height
	var found = foundPassArray;
	found.length = layers.length;
	found.fill(false);
	for (var i = 0; i < layers.length; i++) {
		var lay = layers[i];
		if (lay.type === LAYERTYPE_PASS) {
			lay.lastTexUsage.length = 0;
			lay.usedNextFrame = false;	
			
			//init resolution
			if (lay.resolution === PASSRESOLUTION_DISPLAY) {//display
				lay.width = display.width;
				lay.height = display.height;
				
			} else if (lay.resolution === PASSRESOLUTION_FIXED) {//fixed 
				lay.width = lay.fixedWidth;
				lay.height = lay.fixedHeight;
				
			} else {//copy from preceding layer
				var pl = layers[lay.resolution-2];
				lay.width = pl.width;
				lay.height = pl.height;
			}
		}
	}
	
	//find what pass layers are used next frame, they will have their own swap textures
	for (var i = 0; i < layers.length; i++) {
		var lay = layers[i];
		if (lay.type === LAYERTYPE_PASS) {
			for (var u = 0; u < lay.layerTexUniforms.length; u++) {
				var lu = lay.layerTexUniforms[u];
				if (lu.layerId >= i) {
					var ulay = layers[lu.layerId];
					if (ulay.type === LAYERTYPE_PASS) layers[lu.layerId].usedNextFrame = true;
				}
			}
		}
	}
	
	//find last usage of each pass texture and allocate swap textures
	for (var i = layers.length-1; i > -1; i--) {
		var lay = layers[i];
		if (lay.type === LAYERTYPE_PASS) {
			if (lay.usedNextFrame) {
				if (lay.hasOwnRT) {
					var rt = lay.renderTexture;
					if (rt.width !== lay.width || rt.height !== lay.height) {//resize existing swap textures
						rt.SetSize(lay.width,lay.height);
						lay.nextRT.SetSize(lay.width,lay.height);
					}
					
				} else {//allocate new swap textures
					lay.renderTexture = CreateRT(lay.width,lay.height);
					lay.nextRT = CreateRT(lay.width,lay.height);
					lay.hasOwnRT = true;
				}
				
			} else {
				if (lay.hasOwnRT) {//free swap textures
					lay.renderTexture.Delete();
					lay.nextRT.Delete();
					lay.hasOwnRT = false;
				}
			}
		
			for (var u = 0; u < lay.layerTexUniforms.length; u++) {
				var lu = lay.layerTexUniforms[u],
					ulay = layers[lu.layerId];
				if (ulay.type === LAYERTYPE_PASS) {
					if (!found[lu.layerId]) {
						if (!ulay.usedNextFrame) lay.lastTexUsage.push(lu.layerId);
						found[lu.layerId] = true;
					}
				}
			}
		}
	}
	
	//allocate pass rendertextures that dont have their own swap textures
	var oldTexs = passTextures, lastPass = passes[passes.length-1];
	passTextures = passTexturesOld;
	passTexturesOld = oldTexs;
	
	for (var i = 0; i < layers.length; i++) {
		var lay = layers[i];
		if (lay.type === LAYERTYPE_PASS && !lay.usedNextFrame) {

			if (lay === lastPass) {
				lay.renderTexture = display;
			
			} else if (found[i]) {
				var pti, ptl = unusedPassTextures.length, tw = lay.width, th = lay.height;
				for (pti = 0; pti < ptl; pti++) {//search for existing unused pass texture
					var pt = unusedPassTextures[pti];
					if (pt.width === tw && pt.height === th) {
						lay.renderTexture = pt;
						
						ptl--;
						if (pti !== ptl) unusedPassTextures[pti] = unusedPassTextures[ptl];
						unusedPassTextures.length = ptl;
						pti = -1;
						break;
					}
				}
				
				if (pti >= ptl) {
					//no unused texture, look in old textures
					ptl = oldTexs.length;
					for (pti = 0; pti < ptl; pti++) {
						var pt = oldTexs[pti];
						if (pt.width === tw && pt.height === th) {
							lay.renderTexture = pt;
						
							ptl--;
							if (pti !== ptl) oldTexs[pti] = oldTexs[ptl];
							oldTexs.length = ptl;
							pti = -1;
							break;
						}
					}
					
					if (pti >= ptl) {
						//no existing textures, create new
						var rt = CreateRT(tw, th);
						passTextures.push(rt);
						lay.renderTexture = rt;
					}
				}
				
			} else {
				lay.renderTexture = null;
			}
			
			for (var k = 0; k < lay.lastTexUsage.length; k++) unusedPassTextures.push(layers[lay.lastTexUsage[k]].renderTexture);
		}
	}
	
	//delete old unusued textures
	for (var i = 0; i < oldTexs.length; i++) oldTexs[i].Delete();
	oldTexs.length = 0;
	unusedPassTextures.length = 0;
}


//render pass layer
function RenderPass(pass) {
	if (!pass.program || !pass.renderTexture) return;

	pass.renderTexture.Bind();
	gl.useProgram(pass.program);
	
	if (pass.paramsUniform) {
		gl.uniform4f(pass.paramsUniform, display.width,display.height,animationTime,framerate);
	}
	
	if (pass.mouseUniform) {
		gl.uniform4f(pass.mouseUniform, canvasMouseX,canvasMouseY, leftMouseDown,rightMouseDown);
	}
	
	if (pass.keyboardUniform) {
		gl.uniform4uiv(pass.keyboardUniform, keyboardState);
	}
	
	var texUni = pass.layerTexUniforms;
	for (var i = 0; i < texUni.length; i++) {
		var tu = texUni[i], lay = layers[tu.layerId], tex = null;
		switch (lay.type) {
			case LAYERTYPE_PASS:
				tex = (lay.hasOwnRT ? lay.nextRT.texture : lay.renderTexture.texture);
				break;
				
			case LAYERTYPE_IMAGE:
				tex = lay.texture;
				break;
				
			case LAYERTYPE_JSON:
				tex = lay.texture;
				break;
		}
		if (tex) BindTexture(tu.uniform, tex);

	}
	
	var sizeUni = pass.layerSizeUniforms;
	for (var i = 0; i < sizeUni.length; i++) {
		var tu = sizeUni[i], lay = layers[tu.layerId];
		if (lay.type === LAYERTYPE_SHAREDGLSL) continue;
		
		gl.uniform4f(tu.uniform, lay.width,lay.height, 1/lay.width,1/lay.height);
	}
	
	gl.drawArrays(gl.TRIANGLES,0,3);
	
	UnbindAllTextures();
}


//render back buffer passes
function RenderBufferPasses() {
	for (var l = 0, len = passes.length-1; l < len; l++) RenderPass(passes[l]);
}

//swap back buffer textures
function SwapBackBuffers() {
	for (var l = 0, len = passes.length-1; l < len; l++) {
		var pass = passes[l];
		if (pass.hasOwnRT) {
			var tmp = pass.renderTexture;
			pass.renderTexture = pass.nextRT;
			pass.nextRT = tmp;
		}
	}
}

