

var canvasMouseX = 0, canvasMouseY = 0, leftMouseDown = 0, rightMouseDown = 0, lastTouchX = 0, lastTouchY = 0, lastTouchId = -1, mouseSensitivity = 1, currentGamepad = null, gamepadLastInput = -1, gamepadLastTimestamp = 0, gamepadMouseMap = 0,

keyCodeLUT = {}, keyboardState = new Uint32Array(4),
KEYBOARD_CODES = ["Escape","Digit1","Digit2","Digit3","Digit4","Digit5","Digit6","Digit7","Digit8","Digit9","Digit0","Minus","Equal","Backspace","Tab","KeyQ","KeyW","KeyE","KeyR","KeyT","KeyY","KeyU","KeyI","KeyO","KeyP","BracketLeft","BracketRight","Enter","ControlLeft","KeyA","KeyS","KeyD","KeyF","KeyG","KeyH","KeyJ","KeyK","KeyL","Semicolon","Quote","Backquote","ShiftLeft","Backslash","KeyZ","KeyX","KeyC","KeyV","KeyB","KeyN","KeyM","Comma","Period","Slash","ShiftRight","NumpadMultiply","AltLeft","Space","CapsLock","F1","F2","F3","F4","F5","F6","F7","F8","F9","F10","ScrollLock","Numpad7","Numpad8","Numpad9","NumpadSubtract","Numpad4","Numpad5","Numpad6","NumpadAdd","Numpad1","Numpad2","Numpad3","Numpad0","NumpadDecimal","IntlBackslash","F11","F12","NumpadEqual","NumpadComma","NumpadEnter","ControlRight","NumpadDivide","AltRight","NumLock","Home","ArrowUp","PageUp","ArrowLeft","ArrowRight","End","ArrowDown","PageDown","Insert","Delete"];



function InitializeMouseKeyboard() {
	//canvas mouse events
	quickGLCanvas.addEventListener("mousedown", function(e) {
		if (e.button === 0) {
			if (captureMouse) CaptureMouse();
			leftMouseDown = 1;
			
		} else if (e.button === 2) {
			rightMouseDown = 1;
			e.preventDefault();
		}
	});
	quickGLCanvas.addEventListener("mouseup", function(e) {
		if (e.button === 0) leftMouseDown = 0;
		else if (e.button === 2) {
			rightMouseDown = 0;
			e.preventDefault();
		}
	});
	quickGLCanvas.addEventListener("contextmenu", function(e) {
		e.preventDefault();
	});
	
	quickGLCanvas.addEventListener("mousemove", function(e) {
		if (captureMouse) {
			canvasMouseX += e.movementX*pixelScaling*mouseSensitivity;
			canvasMouseY += e.movementY*-pixelScaling*mouseSensitivity;
			
		} else {
			canvasMouseX = Math.floor(e.clientX*pixelScaling);
			canvasMouseY = Math.floor(display.height-1-e.clientY*pixelScaling);
		}
	});
	
	
	//touch events
	quickGLCanvas.addEventListener("touchstart", function(e) {
		if (document.fullscreenElement !== quickGLCanvas) quickGLCanvas.requestFullscreen();
		if (!launched) return;
		
		var tch = e.changedTouches[0];
		if (captureMouse) {
			canvasMouseX = 0;
			canvasMouseY = 0;
			lastTouchId = tch.identifier;
			lastTouchX = Math.floor(tch.clientX*pixelScaling);
			lastTouchY = Math.floor(display.height-1-tch.clientY*pixelScaling);
			
		} else {
			canvasMouseX = Math.floor(tch.clientX*pixelScaling);
			canvasMouseY = Math.floor(display.height-1-tch.clientY*pixelScaling);
		}
		
		leftMouseDown = 1;
		
		e.preventDefault();
		e.stopPropagation();
	});
	
	quickGLCanvas.addEventListener("touchmove", function(e) {
		if (!launched) return;
	
		var tch = e.changedTouches[0];
		if (captureMouse) {
			if (tch.identifier === lastTouchId) {
				canvasMouseX += (tch.clientX-lastTouchX)*pixelScaling*mouseSensitivity;
				canvasMouseY += (tch.clientY-lastTouchY)*-pixelScaling*mouseSensitivity;
				lastTouchX = tch.clientX;
				lastTouchY = tch.clientY;
			
			} else {
				canvasMouseX = 0;
				canvasMouseY = 0;
				lastTouchId = tch.identifier;
				lastTouchX = tch.clientX;
				lastTouchY = tch.clientY;
			}
			
		} else {
			canvasMouseX = Math.floor(tch.clientX*pixelScaling);
			canvasMouseY = Math.floor(display.height-1-tch.clientY*pixelScaling);
		}
		
		leftMouseDown = 1;
		
		e.preventDefault();
		e.stopPropagation();
	});
	
	quickGLCanvas.addEventListener("touchend", function(e) {
		if (!launched) return;
	
		var tch = e.changedTouches[0];
		if (captureMouse) {
			if (tch.identifier === lastTouchId) {
				canvasMouseX = 0;
				canvasMouseY = 0;
			}
		}
		
		if (e.targetTouches.length === 0) leftMouseDown = 0;
		
		e.preventDefault();
		e.stopPropagation();
	});
	quickGLCanvas.addEventListener("touchcancel", function(e) {
		if (!launched) return;
	
		var tch = e.changedTouches[0];
		if (captureMouse) {
			if (tch.identifier === lastTouchId) {
				canvasMouseX = 0;
				canvasMouseY = 0;
			}
		}
		
		if (e.targetTouches.length === 0) leftMouseDown = 0;
		
		e.preventDefault();
		e.stopPropagation();
	});
	
	
	//canvas keyboard events
	for (var i = 0; i < KEYBOARD_CODES.length; i++) keyCodeLUT[KEYBOARD_CODES[i]] = i;
	
	window.addEventListener("keydown", function(e) {
		if (!launched) return;
	
		if (e.key === playHotkey) {
			Play(!playing);
			e.preventDefault();
			e.stopPropagation();
			return;
		}
	
		var id = keyCodeLUT[e.code];
		if (id !== undefined) {
			var aid = Math.floor(id/32), bit = id%32;
			keyboardState[aid] |= 1<<bit;
			e.preventDefault();
			e.stopPropagation();
		}
	});
	
	window.addEventListener("keyup", function(e) {
		if (!launched) return;
	
		if (e.key === playHotkey) {
			e.preventDefault();
			e.stopPropagation();
			return;
		}
	
		var id = keyCodeLUT[e.code];
		if (id !== undefined) {
			var aid = Math.floor(id/32), bit = id%32;
			keyboardState[aid] &= ~(1<<bit);
			e.preventDefault();
			e.stopPropagation();
		}
	});
}


function CaptureMouse() {
	if (document.pointerLockElement !== quickGLCanvas) quickGLCanvas.requestPointerLock({"unadjustedMovement":true});
}


//gamepad to mouse/keyboard system
function InitGamepadEvents() {
	gamepadMouseMap = buildConfig["GamepadMouse"];

	//detect gamepad connected
	window.addEventListener("gamepadconnected", function(e) {
		currentGamepad = e.gamepad;
		gamepadLastInput = currentTime;
	});
}

function UpdateGamepad(delta) {
	//is gamepad enabled?
	if (!currentGamepad || !currentGamepad.connected) return;
	
	//disable if no recent inputs
	if (currentGamepad.timestamp != gamepadLastTimestamp) {
		gamepadLastTimestamp = currentGamepad.timestamp;
		gamepadLastInput = currentTime;
		
	} else if ((currentTime-gamepadLastInput) > 3000) return;

	//mapping
	delta /= 1000;
	
	//joystick axes to mouse
	if (gamepadMouseMap) {
		var ind = (gamepadMouseMap-1)*2,
			jsX = currentGamepad.axes[ind],
			jsY = currentGamepad.axes[ind+1],
			scale = display.height*mouseSensitivity*delta;
		
		jsX = jsX*jsX*Math.sign(jsX);
		jsY = jsY*jsY*Math.sign(jsY);
		
		if (captureMouse) {
			canvasMouseX = jsX*scale;
			canvasMouseY = -jsY*scale;
			
		} else {
			scale *= 0.25;
			canvasMouseX = Math.min(Math.max(canvasMouseX+jsX*scale, 0), display.width);
			canvasMouseY = Math.min(Math.max(canvasMouseY+jsY*scale, 0), display.height);
		}
	}
	
	if (buildGamepadMappings) {
		keyboardState.fill(0);
		leftMouseDown = rightMouseDown = 0;
		
		//buttons to keys/clicks
		for (var i = 0; i < 17; i++) {
			var mapInp = buildGamepadMappings[i];
			if (mapInp && currentGamepad.buttons[i].pressed) {
				mapInp--;
				if (mapInp >= KEYBOARD_CODES.length) {
					//mouse click
					if (mapInp === KEYBOARD_CODES.length) leftMouseDown = 1;
					else rightMouseDown = 1;
					
				} else {
					//key press
					var aid = Math.floor(mapInp/32), bit = mapInp%32;
					keyboardState[aid] |= 1<<bit;
				}
			}
		}
		
		//axes to keys/clicks
		for (var i = 17; i < 25; i++) {
			var mapInp = buildGamepadMappings[i];
			if (mapInp) {
				var dirId = i-17, axId = Math.floor(dirId/2);
				dirId = ((dirId+axId)%2)*2-1;
				if (currentGamepad.axes[axId]*dirId > 0.5) {
					mapInp--;
					if (mapInp >= KEYBOARD_CODES.length) {
						//mouse click
						if (mapInp === KEYBOARD_CODES.length) leftMouseDown = 1;
						else rightMouseDown = 1;
					
					} else {
						//key press
						var aid = Math.floor(mapInp/32), bit = mapInp%32;
						keyboardState[aid] |= 1<<bit;
					}
				}
			}
		}
	}
}

/*snippet to print keycode names for about list

var str = "";
for (var i = 0; i < KEYBOARD_CODES.length; i++) {
	if (i) str += ", ";
	str += KEYBOARD_CODES[i].replaceAll("Key","").replaceAll("Digit","").toUpperCase();
}
console.log(str);
*/


/*snippet to grab key codes from mozilla docs

(function() {
var rows = temp0.childNodes,
	skip = 1, lastCode = "Delete",
	ignore = {"Unidentified":1, "PrintScreen":1, "F13":1,"F14":1,"F15":1,"F16":1,"F17":1,"F18":1,"F19":1,"F20":1,"F21":1,"F22":1,"F23":1,"F24":1,"F25":1,
			"KanaMode":1,"Lang1":1,"Lang2":1,"IntlRo":1,"Convert":1,"NonConvert":1,"IntlYen":1, "MediaTrackPrevious":1,"MediaTrackNext":1,"AudioVolumeMute":1,"LaunchApp2":1,
			"Pause":1,"MediaPlayPause":1,"MediaStop":1,"VolumeDown":1,"VolumeUp":1,"BrowserHome":1,"PrintScreen":1,"OSLeft":1,"OSRight":1,"ContextMenu":1,"Power":1},
	keyCodes = [];
for (var r = 0; r < rows.length; r++) {
	var ele = rows[r];
	if (ele.tagName && ele.tagName === "TR") {
		var col = ele.childNodes, code = null;
		for (var c = 0; c < col.length; c++) {
			var cele = col[c];
			if (cele.tagName && cele.tagName === "TD") {
				code = cele.textContent;
				break;
			}
		}
		if (!code) continue;
	
		code = code.substring(1, code.indexOf('"',1));
		if (code.length === 0 || ignore[code]) continue;
		
		if (skip) {
			skip--;
			continue;
		}
	
		keyCodes.push(code);
		if (code === lastCode) break;
	}
}
console.log(JSON.stringify(keyCodes));
}());
*/

