

var buildPanel, buildConfig, buildModeIdEle, buildOptionConfig, buildModeSelect, buildOptionSelect, buildSaveBuffersEle,
buildModes = [], buildOptions = [], buildModeId = -1, buildOptionId = -1, buildSaveLayers = [], buildSaveChecks = [], buildCheckedLayers = [], buildGamepadMappings = null, buildGamepadMouseMap = 0, buildSelectedGamepad = -1,
GAMEPAD_MAP = null,
GAMEPAD_INPUTS = [//buttons
"A","B","X","Y", "LeftBump","RightBump","LeftTrig","RightTrig", "Back","Forward", "LeftStick","RightStick", "Up","Down","Left","Right", "Home",
//axes
"LSLeft","LSRight","LSDown","LSUp","RSLeft","RSRight","RSDown","RSUp"];


function InitializeStandaloneBuild() {
	buildPanel = document.getElementById("BuildPanel");
	buildModeSelect = document.getElementById("BuildModeSelect");
	buildOptionSelect = document.getElementById("BuildOptionSelect");
	buildModeIdEle = document.getElementById("BuildModeId");
	buildSaveBuffersEle = document.getElementById("BuildSaveBuffers");
	
	buildConfig = new InputGUI(["BuildLaunch","BuildPause", "BuildLaunchText","BuildPauseText", "BuildAudio", "BuildBGColor","BuildFGColor","BuildSaveLoad","BuildCSS","GamepadMouse"]);
	buildOptionConfig = new InputGUI(["BuildModeName","BuildModeAudio", "BuildOptionName","BuildOptionSlider","BuildOptionMin","BuildOptionMax","BuildOptionDefault", "BuildIcon", "GamepadKey"]);
	
	GAMEPAD_MAP = ["None"].concat(KEYBOARD_CODES);
	GAMEPAD_MAP.push("Left Mouse Click");
	GAMEPAD_MAP.push("Right Mouse Click");
	
	buildConfig["GamepadMouse"].SetSelectOptions(["None", "Left Stick", "Right Stick"]);
	var gpKey = buildOptionConfig["GamepadKey"];
	gpKey.SetSelectOptions(GAMEPAD_MAP);
	gpKey.element.addEventListener("change",function() {
		if (buildSelectedGamepad === -1) return;
		
		if (!buildGamepadMappings) {
			buildGamepadMappings = new Array(GAMEPAD_INPUTS.length);
			buildGamepadMappings.fill(0);
		}
		
		buildGamepadMappings[buildSelectedGamepad] = gpKey.element.selectedIndex;
	});
	
	//build modes
	BEC("BuildAddMode", function() {
		//add new mode
		UpdateBuildMode();
		
		var nm = new BuildMode();
		buildModes.push(nm);
		
		var opt = document.createElement("option");
		opt.innerText = nm["n"];
		buildModeSelect.appendChild(opt);
		
		SelectBuildMode(buildModes.length-1);
	});
	
	BEC("BuildDeleteMode", function() {
		//delete selected mode
		if (buildModeId === -1) return;
		buildModes.splice(buildModeId, 1);
		buildModeSelect.removeChild(buildModeSelect.childNodes[buildModeId]);
		SelectBuildMode(Math.min(buildModeId, buildModes.length-1));
	});
	
	buildModeSelect.addEventListener("change", function(e) {
		UpdateBuildMode();
		SelectBuildMode(parseInt(e.target.selectedIndex));
	});
	

	//build options
	BEC("BuildAddOption", function() {
		//add new option
		UpdateBuildOption();
		
		var no = new BuildOption();
		buildOptions.push(no);
		
		var opt = document.createElement("option");
		opt.innerText = no["n"];
		buildOptionSelect.appendChild(opt);
		
		SelectBuildOption(buildOptions.length-1);
	});
	
	BEC("BuildDeleteOption", function() {
		//delete selected option
		if (buildOptionId === -1) return;
		buildOptions.splice(buildOptionId, 1);
		buildOptionSelect.removeChild(buildOptionSelect.childNodes[buildOptionId]);
		SelectBuildOption(Math.min(buildOptionId, buildOptions.length-1));
	});
	
	buildOptionSelect.addEventListener("change", function(e) {
		UpdateBuildOption();
		SelectBuildOption(parseInt(e.target.selectedIndex));
	});
	
	
	//go back to project panel
	BEC("BuildBack", function() {
		UpdateBuildMode();
		UpdateBuildOption();
		UpdateCheckedLayers();
	
		EV(buildPanel,false);
		EV(projectPanel,true);
	});
	
	//build and save standalone html file
	BEC("BuildBuild", function() {
		UpdateBuildMode();
		UpdateBuildOption();
		UpdateCheckedLayers();
	
		var ot = "<", ct = ">", tpscript = ot+"script type='text/plain' id='", cscript = ot+"/script"+ct,
			html = ot+"html"+ct+ot+"head"+ct+ot+"title"+ct+project.name+ot+"/title"+ct,
			icon = buildOptionConfig["BuildIcon"].value;
			
		if (icon.length > 0) html += "<link rel='icon' href='"+icon+"'>";
		
		var pjson = ProjectToJSON();
		pjson["b"]["BuildLaunchText"] = EncodeURLBase64(pjson["b"]["BuildLaunchText"]);//encode as url safe base64 so html doesnt interfere
		pjson["b"]["BuildPauseText"] = EncodeURLBase64(pjson["b"]["BuildPauseText"]);
		html += tpscript+"GCPJS'"+ct+JSON.stringify(pjson)+cscript;
		
		var imgCanvas = null, img2d;
		for (var i = 0; i < layers.length; i++) {
			var lay = layers[i];
			if (lay.type === LAYERTYPE_IMAGE) {
				if (lay.width === 0) continue;
				
				if (imgCanvas === null) {
					imgCanvas = document.createElement("canvas");
					img2d = imgCanvas.getContext("2d");
				}
				
				imgCanvas.width = lay.width;
				imgCanvas.height = lay.height;
				img2d.drawImage(lay.image,0,0);	
				html += tpscript+"LAYER"+i+"'"+ct+imgCanvas.toDataURL("image/png")+cscript;
				
			} else if (lay.type === LAYERTYPE_JSON) {
				if (!lay.array) continue;
				
				html += tpscript+"LAYER"+i+"'"+ct+EncodeURLBase64(JSON.stringify(lay.array))+cscript;
				
			}
		}
		
		var stmp = document.getElementById("StandaloneTemplate.txt").textContent;
		if (stmp[stmp.length-1] === "\n") stmp.length--;
		
		html += ot+"script type='text/javascript'"+ct+
				DecodeURLBase64(stmp);
			
		if (exportDataURL) URL.revokeObjectURL(exportDataURL);
		exportDataURL = URL.createObjectURL(new Blob([html]));
		SaveFilePrompt(exportDataURL, project.name+".html");
	});
	
	
	//gamepad button to key bindings
	for (var i = 0; i < GAMEPAD_INPUTS.length; i++) {
		var btn = document.getElementById("Gamepad"+GAMEPAD_INPUTS[i]);
		btn.gamepadInputId = i;
		btn.addEventListener("click", SelectGamepadInput);
	}
}


/**@constructor*/
function BuildMode() {
	this["n"] = "New Mode";
	this["a"] = "";
}

/**@constructor*/
function BuildOption() {
	this["n"] = "New Option";
	this["s"] = false;
	this["m"] = "";
	this["u"] = "";
	this["d"] = "";
}


//reload mode/option selects
function UpdateBuildSelects() {
	buildModeSelect.innerHTML = "";
	for (var i = 0; i < buildModes.length; i++) {
		var opt = document.createElement("option");
		opt.innerText = buildModes[i]["n"];
		buildModeSelect.appendChild(opt);
	}
	SelectBuildMode(buildModes.length-1);
	
	buildOptionSelect.innerHTML = "";
	for (var i = 0; i < buildOptions.length; i++) {
		var opt = document.createElement("option");
		opt.innerText = buildOptions[i]["n"];
		buildOptionSelect.appendChild(opt);
	}
	SelectBuildOption(buildOptions.length-1);
}


//init save buffer checkboxes
function UpdateBuildSaveBuffers() {
	buildSaveBuffersEle.innerHTML = "";
	buildSaveLayers.length = 0;
	buildSaveChecks.length = 0;
	for (var i = 0; i < layers.length; i++) {
		var lay = layers[i];
		if (lay.type === LAYERTYPE_PASS && lay.resolution === PASSRESOLUTION_FIXED) {
			var lbl = document.createElement("label"),
				chk = document.createElement("input");
			lbl.innerText = (buildSaveChecks.length?", ":" ")+lay.name+LayerIdName(i);
			if (buildCheckedLayers.indexOf(i) !== -1) chk.checked = true;
			chk.type = "checkbox";
			lbl.appendChild(chk);
			buildSaveBuffersEle.appendChild(lbl);
			
			buildSaveChecks.push(chk);
			buildSaveLayers.push(i);
		}
	}
}

//update checked layers from ui checkboxes
function UpdateCheckedLayers() {
	buildCheckedLayers.length = 0;
	for (var i = 0; i < buildSaveChecks.length; i++) {
		if (buildSaveChecks[i].checked) buildCheckedLayers.push(buildSaveLayers[i]);
	}
}


//update mode values from ui elements
function UpdateBuildMode() {
	if (buildModeId === -1) return;
	var mode = buildModes[buildModeId];
	buildModeSelect.childNodes[buildModeId].innerText = mode["n"] = buildOptionConfig["BuildModeName"].value;
	mode["a"] = buildOptionConfig["BuildModeAudio"].value;
}

//set ui elements from mode values
function SelectBuildMode(id) {
	buildModeSelect.selectedIndex = buildModeId = id;
	if (id === -1) return;
	var mode = buildModes[id];
	buildOptionConfig["BuildModeName"].SetValue(mode["n"]);
	buildOptionConfig["BuildModeAudio"].SetValue(mode["a"]);
	buildModeIdEle.innerText = id;
}


//update option values from ui elements
function UpdateBuildOption() {
	if (buildOptionId === -1) return;
	var opt = buildOptions[buildOptionId];
	buildOptionSelect.childNodes[buildOptionId].innerText = opt["n"] = buildOptionConfig["BuildOptionName"].value;
	opt["s"] = buildOptionConfig["BuildOptionSlider"].value;
	opt["m"] = buildOptionConfig["BuildOptionMin"].value;
	opt["u"] = buildOptionConfig["BuildOptionMax"].value;
	opt["d"] = buildOptionConfig["BuildOptionDefault"].value;
}

//set ui elements from option values
function SelectBuildOption(id) {
	buildOptionSelect.selectedIndex = buildOptionId = id;
	if (id === -1) return;
	var opt = buildOptions[id];
	buildOptionConfig["BuildOptionName"].SetValue(opt["n"]);
	buildOptionConfig["BuildOptionSlider"].SetValue(opt["s"]);
	buildOptionConfig["BuildOptionMin"].SetValue(opt["m"]);
	buildOptionConfig["BuildOptionMax"].SetValue(opt["u"]);
	buildOptionConfig["BuildOptionDefault"].SetValue(opt["d"]);
}


//select gamepad button
function SelectGamepadInput(e) {
	var id = e.target.gamepadInputId;
	buildSelectedGamepad = id;
	if (buildGamepadMappings) {
		buildOptionConfig["GamepadKey"].SetValue(buildGamepadMappings[id]);
	}
}
