
var splashPanel, mainPanel, layersPanel, projectPanel, newProjectPanel, openProjectPanel, dialogPanel, glslErrorsPanel, aboutPanel,
sidePanel, renderMenuPanel, renderingPanel, renderCompletePanel,
dialogTitle,dialogText,dialogNo,onDialogYes,onDialogNo,onDialogData,dialogReturnPanel,
playIcon, pauseIcon, imageLayerInfo, glslLayer, imageLayer, jsonLayer, layerTypePanels,
newProjectSelect,openProjectSelect,
glslEditor, glslHighlight, glslErrors, glslCompiling, displayingErrors = false, displayingCompile = false,
projectConfig, sidebarInput, layersConfig, passLayerConfig, imageLayerConfig, jsonLayerConfig, layerTypeConfigs,
loadingData = false, layerName, cssStyle,
renderConfig, renderProgress, renderImage,
exportDataURL,

THEMES = ["Network", "Turqoise", "Skyline", "Forge", "Twilight", "Sun Shine", "Mono Dark", "Mono Light", "Bright Green"],
HIGHLIGHT_REFRESH_RATES = ["Realtime", "1000", "100", "50", "20", "10", "4", "2", "1"],
TEMPLATES = ["Blank", "Graphing 1D", "Graphing 2D", "Graphing 3D", "Number Font", "Block Tennis Game", "2D Shapes", "3D Shapes"];


function InitializeUI() {
	//panels
	splashPanel = document.getElementById("SplashPanel");
	mainPanel = document.getElementById("MainPanel");
	layersPanel = document.getElementById("LayerPanel");
	projectPanel = document.getElementById("ProjectPanel");
	newProjectPanel = document.getElementById("NewProjectPanel");
	openProjectPanel = document.getElementById("OpenProjectPanel");
	dialogPanel = document.getElementById("DialogPanel");
	glslErrorsPanel = document.getElementById("GLSLErrorPanel");
	aboutPanel = document.getElementById("AboutPanel");
	renderMenuPanel = document.getElementById("RenderMenuPanel");
	renderingPanel = document.getElementById("RenderingPanel");
	renderCompletePanel = document.getElementById("RenderCompletePanel");
	sidePanel = document.getElementById("SidePanel");

	//customizable dialog menu	
	dialogTitle = document.getElementById("DialogTitle");
	dialogText = document.getElementById("DialogText");	
	dialogNo = document.getElementById("DialogNo");
	BEC("DialogYes", function() {
		if (onDialogYes) onDialogYes(onDialogData);
		EV(dialogPanel,false);
		EV(dialogReturnPanel,true);
	});
	BEC("DialogNo", function() {
		if (onDialogNo) onDialogNo(onDialogData);
		EV(dialogPanel,false);
		EV(dialogReturnPanel,true);
	});
	
	
	//sidebar buttons	
	sidebarInput = new InputGUI(["AnimTime", "Layers"]);
	layerName = document.getElementById("LayerName");
	
	BEC("ProjectBtn", function() {
		UpdateLayerGLSL();
		if (playing) PlayAnimation(false);
		
		appStatus = APPSTATUS_PROJECT;
		EV(mainPanel,false);
		EV(projectPanel,true);
	});
	BEC("AboutBtn", function() {
		appStatus = APPSTATUS_ABOUT;
		EV(mainPanel,false);
		EV(aboutPanel,true);
	});
	
	playIcon = document.getElementById("PlayAnimIcon");
	pauseIcon = document.getElementById("PauseAnimIcon");
	BEC("PlayAnimBtn", function(e) {
		PlayAnimation(!playing);
	});
	BEC("StopAnimBtn", function() {
		playing = false;
		sidebarInput["AnimTime"].SetValue(0);
		EV(playIcon,!playing,true);
		EV(pauseIcon,playing,true);
	});
	
	sidebarInput["Layers"].element.addEventListener("change", function(e) {
		//change selected layer
		UpdateLayerGLSL();
		SetSidebarLayer(e.target.selectedIndex);
	});
	
	BEC("AddLayerBtn", function() {
		UpdateLayerGLSL();
	
		var lay = BlankPassLayer();
		layers.push(lay);
		passes.push(lay);
		
		var newInd = layers.length-1;
		sidebarInput["Layers"].SetSelectOptions(GetLayerNames(), newInd);
		SetSidebarLayer(newInd);
	});
	BEC("DeleteLayerBtn", function() {
		if (layer.type === LAYERTYPE_PASS && passes.length === 1) {
			CantDeleteLastLayer(mainPanel);
			return;
		}
		ConfirmDeleteDialog(layer.name+"(Layer"+layerId+")", mainPanel, OnMainLayerDeleteYes);
	});
	
	BEC("ConfigLayer", function() {
		UpdateLayerGLSL();
		if (playing) PlayAnimation(false);
		SetConfigLayer(layerId);
		glslEditor.codeLastChanged = 0;
	
		appStatus = APPSTATUS_CONFIGLAYERS;
		EV(mainPanel,false);
		EV(layersPanel,true);
	});
	
	
	//glsl code editor layer
	glslLayer = document.getElementById("GLSLLayer");
	glslCompiling = document.getElementById("GLSLCompiling");
	glslErrors = document.getElementById("GLSLErrors");
	glslHighlight = new SyntaxHighlighting("hl-c","hl-s","hl-q","hl-a","hl-p","hl-d",LANGUAGE_GLSL);
	glslEditor = new CodeEditor("GLSLCode", "\t",true,true, "GLSLHighlight",glslHighlight);
	
	cssStyle = document.createElement("style");
	document.head.appendChild(cssStyle);
	
	BEC("CloseErrors", function() {
		EV(glslErrorsPanel,false);
	});
	
	
	//image texture layer
	imageLayer = document.getElementById("ImageLayer");
	imageLayerInfo = document.getElementById("ImageInfo");
	
	BEC("ImageLoad", function() {
		LoadFilePrompt(OnImageFileLoad, "image/*");
	});
	
	
	//json texture layer
	jsonLayer = document.getElementById("JSONLayer");
	
	BEC("JSONLoad", function() {
		LoadFilePrompt(OnJSONFileLoad);
	});
	
	layerTypePanels = [glslLayer,glslLayer,imageLayer,jsonLayer];
	
	
	//configure layers panel
	passLayerConfig = document.getElementById("PassLayerConfig");
	imageLayerConfig = document.getElementById("ImageLayerConfig");
	jsonLayerConfig = document.getElementById("JSONLayerConfig");
	layerTypeConfigs = [passLayerConfig,null,imageLayerConfig,jsonLayerConfig];
	
	layersConfig = new InputGUI(["LayersSelect","LayersName","LayersType", "PassResolution","PassWidth","PassHeight", "ImageLinear","ImageMipMap","ImageRepX","ImageRepY", "JSONFormat","JSONSelect"]);
	layersConfig["JSONFormat"].SetSelectOptions(["Grayscale", "RG", "RGB", "RGBA"]);
	
	layersConfig["JSONSelect"].element.addEventListener("change", function(e) {
		SelectJSONArray(e.target.selectedIndex);
	});
	
	layersConfig["LayersSelect"].element.addEventListener("change", function(e) {
		UpdateLayerSettings();
	
		//change selected layer
		SetConfigLayer(e.target.selectedIndex);
	});
	
	layersConfig["LayersType"].element.addEventListener("change", function(e) {
		//change selected layer type
		var newType = e.target.selectedIndex;
		if (newType === layer.type) return;
		
		var newLay,
			recalcPasses = (layer.type===LAYERTYPE_PASS || newType===LAYERTYPE_PASS);
		switch (newType) {
			case LAYERTYPE_PASS: newLay = BlankPassLayer(); break;
			case LAYERTYPE_IMAGE: newLay = new ImageLayer(null); break;
			case LAYERTYPE_SHAREDGLSL: newLay = new SharedGLSLLayer(null,null); break;
			case LAYERTYPE_JSON: newLay = new JSONLayer(null); break;
		}
		
		newLay.name = layersConfig["LayersName"].value;
		if (layer.glsl.length) newLay.glsl = layer.glsl;
		
		layer.Delete();
		layers[layerId] = newLay;
		
		if (recalcPasses) {
			passes.length = 0;
			for (var i = 0; i < layers.length; i++) {
				var lay = layers[i];
				if (lay.type === LAYERTYPE_PASS) passes.push(lay);
			}
		}
		
		SetConfigLayer(layerId);
	});
	
	BEC("LayersAdd", function() {
		UpdateLayerSettings();
		
		var lay = BlankPassLayer();
		layers.push(lay);
		passes.push(lay);
		
		SetConfigLayer(layers.length-1);
	});
	
	BEC("LayersUp", function() {
		if (layerId === 0) return;
		
		UpdateLayerSettings();
		
		var movePass = (layers[layerId-1].type === LAYERTYPE_PASS);
		layers.splice(layerId,1);
		layers.splice(layerId-1,0,layer);
		if (movePass) {
			var pind = passes.indexOf(layer);
			passes.splice(pind,1);
			passes.splice(pind-1,0,layer);
		}
		
		SetConfigLayer(layerId-1);
	});
	BEC("LayersDown", function() {
		if (layerId === layers.length-1) return;
		
		UpdateLayerSettings();
		
		var movePass = (layers[layerId+1].type === LAYERTYPE_PASS);
		layers.splice(layerId,1);
		layers.splice(layerId+1,0,layer);
		if (movePass) {
			var pind = passes.indexOf(layer);
			passes.splice(pind,1);
			passes.splice(pind+1,0,layer);
		}
		
		SetConfigLayer(layerId+1);
	});
	
	BEC("LayersDelete", function() {
		if (layer.type === LAYERTYPE_PASS && passes.length === 1) {
			CantDeleteLastLayer(layersPanel);
			return;
		}
		ConfirmDeleteDialog(layer.name+"(Layer"+layerId+")", layersPanel, OnLayerDeleteYes);
	});
	
	BEC("LayersClose", function() {
		UpdateLayerSettings();
		sidebarInput["Layers"].SetSelectOptions(GetLayerNames(), layerId);
		SetSidebarLayer(layerId);
	
		lastTime = Date.now();
		appStatus = APPSTATUS_MAIN;
		EV(layersPanel,false);
		EV(mainPanel,true);
	});
	


	//project config panel
	SetSelectOptions("HighlightTheme",THEMES);
	SetSelectOptions("HighlightRate",HIGHLIGHT_REFRESH_RATES);
	
	projectConfig = new InputGUI(["ProjectName","FontSize","TabSize","TabAsSpaces","TextWrap","ToggleHighlight","HighlightTheme","HighlightRate","LockFPS","PlayHotkey","CaptureMouse","FullscreenCode"]);
	
	BEC("ProjectOpen", function() {
		SaveProjects();
		SaveProject();
		SetSelectOptions("OpenProjectList",GetProjectNames());
	
		//open open project panel
		appStatus = APPSTATUS_OPENPROJECT;
		EV(projectPanel,false);
		EV(openProjectPanel,true);
	});
	
	BEC("ProjectNew", function() {
		SaveProjects();
		SaveProject();
		
		var pnames = GetProjectNames();
		for (var i = 0; i < TEMPLATES.length; i++) pnames.push(TEMPLATES[i]+" (Template)");
		SetSelectOptions("NewProjectTemplates", pnames);
		
		//open new project panel
		appStatus = APPSTATUS_NEWPROJECT;
		EV(projectPanel,false);
		EV(newProjectPanel,true);
	});
	
	BEC("ProjectDelete", function() {
		if (projects.length === 1) {
			//must have at least 1 project
			MessageDialog("Can't Delete Project", "Must have at least 1 project.", projectPanel);
			return;
		}
	
		//display confirm dialog
		ConfirmDialog("Deletion Confirmation", "Are you certain you want to delete the project?", projectPanel, OnProjectDeleteYes);
	});
	
	BEC("ProjectDone", function() {
		UpdateProjectSettings();
		
		//go back to main panel
		lastTime = Date.now();
		appStatus = APPSTATUS_MAIN;
		EV(projectPanel,false);
		EV(mainPanel,true);
	});
	
	BEC("ProjectSave", function() {
		SaveProjects();
		SaveProject();
	});
	
	BEC("ProjectExport", function() {
		if (exportDataURL) URL.revokeObjectURL(exportDataURL);
		exportDataURL = URL.createObjectURL(new Blob([JSON.stringify(ProjectToJSON())]));
		SaveFilePrompt(exportDataURL, project.name+".json");
	});
	
	BEC("ProjectImport", function() {
		SaveProjects();
		SaveProject();
		LoadFilePrompt(OnProjectImportLoad, null);
	});
	
	BEC("ProjectRender", function() {
		appStatus = APPSTATUS_RENDERMENU;
		EV(projectPanel,false);
		EV(renderMenuPanel,true);
	});
	
	projectConfig["PlayHotkey"].element.addEventListener("keydown", function(e) {
		//detect play hotkey from text field
		var hk = projectConfig["PlayHotkey"];
		hk.SetValue(e.key);
		e.preventDefault();
		e.stopPropagation();
	});
	
	
	BEC("PlayFullscreen", function() {
		UpdateProjectSettings();
		
		//go back to main panel with canvas fullscreen and playing
		lastTime = Date.now();
		appStatus = APPSTATUS_MAIN;
		EV(projectPanel,false);
		EV(mainPanel,true);
		
		PlayAnimation(true);
		quickGLCanvas.requestFullscreen();
	});
	
	
	//create standalone html file of project
	BEC("BuildStandalone", function() {
		UpdateBuildSaveBuffers();
		EV(projectPanel,false);
		EV(buildPanel,true);
	});
	
	
	//new project panel
	newProjectSelect = document.getElementById("NewProjectTemplates");
	
	BEC("NewProjectCancel", function() {
		//close new project
		appStatus = APPSTATUS_PROJECT;
		EV(newProjectPanel,false);
		EV(projectPanel,true);
	});
	BEC("NewProjectCreate", function() {
		if (loadingData) return;
		
		//check if preset template
		var tempInd = newProjectSelect.selectedIndex;
		if (tempInd >= projects.length) {
			//load preset template
			tempInd -= projects.length;
			var tempName = TEMPLATES[tempInd];
						
			FreeProject();
			CreateNewProject(tempName);
		
			OnLoadNewProjectTemplate(null, document.getElementById("Templates_"+tempName.replaceAll(" ","_")+".json").textContent);
		
		} else {
	
			//load new project template from existing project
			var proj = projects[tempInd];
			FreeProject();
			CreateNewProject(proj.name);
		
			loadingData = true;
			IndexedStorage_Load("Project_"+proj.id, OnLoadNewProjectTemplate);
		}
	});
	
	//open project panel
	openProjectSelect = document.getElementById("OpenProjectList");
	
	BEC("OpenProjectCancel", function() {
		//close panel
		appStatus = APPSTATUS_PROJECT;
		EV(openProjectPanel,false);
		EV(projectPanel,true);
	});
	BEC("OpenProject", function() {
		//open project
		if (loadingData) return;

		//move project to front
		var pid = openProjectSelect.selectedIndex,
			proj = projects[pid];
		project = proj;
		projects.splice(pid,1);
		projects.unshift(proj);
		
		//load project
		loadingData = true;
		IndexedStorage_Load("Project_"+proj.id, OnLoadOpenProject);
	});
	
	
	//render menu panel
	renderConfig = new InputGUI(["RenderWidth","RenderHeight","RenderStart","RenderEnd"]);
	
	BEC("RenderCancel", function() {
		appStatus = APPSTATUS_PROJECT;
		EV(renderMenuPanel,false);
		EV(projectPanel,true);
	});
	
	BEC("RenderRender", function() {
		//ensure compiled
		for (var i = 0; i < passes.length; i++) {
			if (!passes[i].program) {
				MessageDialog("Can't Render", "Error you must compile and play at least once before rendering.", renderMenuPanel);
				return;
			}
		}
	
		//start rendering
		quickGLCanvas.width = display.width = renderConfig["RenderWidth"].value;
		quickGLCanvas.height = display.height = renderConfig["RenderHeight"].value;
	
		//resize pass buffers
		ComputePassDependencies();
		
		//init animation time
		var start = renderConfig["RenderStart"].value;
		if (lockFps === 0) {
			animationRefTime = Date.now()-start*1000;
		} else {
			animationTime = start;
			animationRefTime = 0;
		}
		renderEndTime = renderConfig["RenderEnd"].value;
		
		
		appStatus = APPSTATUS_RENDERING;
		EV(renderMenuPanel,false);
		EV(renderingPanel,true);
	});
	
	//rendering panel
	renderProgress = document.getElementById("RenderingProgress");
	
	BEC("RenderingCancel", function() {
		appStatus = APPSTATUS_PROJECT;
		EV(renderingPanel,false);
		EV(projectPanel,true);
		
		//reset resolution
		OnWindowResize();
	});
	
	//render complete panel
	renderImage = document.getElementById("RenderImage");
	
	BEC("RenderCompleteBack", function() {
		appStatus = APPSTATUS_PROJECT;
		EV(renderCompletePanel,false);
		EV(projectPanel,true);
		
		//reset resolution
		OnWindowResize();
	});
	
	BEC("RenderSave", function() {
		if (renderImageURL) SaveFilePrompt(renderImageURL, "GLSLCanvasRender.png");
	});
	
	
	
	//about panel
	BEC("AboutClose", function() {
		//go back to main panel
		lastTime = Date.now();
		appStatus = APPSTATUS_MAIN;
		EV(aboutPanel,false);
		EV(mainPanel,true);
	});
	
	
	//play/pause hotkey
	window.addEventListener("keydown", function(e) {
		if (appStatus === APPSTATUS_MAIN && e.key === playHotkey) {
			if (playing && projectConfig["FullscreenCode"].value) {
				document.exitFullscreen();
				EV(quickGLCanvas,false);
			}
			PlayAnimation(!playing);
			e.preventDefault();
			e.stopPropagation();
		}
	});
	
	UpdateProjectSettings();
}



//display full screen crash message
function FatalCrash(msg) {
	document.body.innerHTML = "<div class='FatalCrash'>"+msg+"</div>";
}

//convert highlight rate select id to ms delay
function IdToHighlightDelay(i) {
	if (i === 0) return 0;
	return 1000/parseFloat(HIGHLIGHT_REFRESH_RATES[i]);
}


//display message via dialog panel
function MessageDialog(title,text,currPanel,onYes,onData) {
	EV(dialogNo,false,true);
	dialogTitle.innerHTML = title;
	dialogText.innerHTML = text;
	dialogReturnPanel = currPanel;
	onDialogYes = onYes;
	onDialogData = onData;
	
	EV(currPanel,false);
	EV(dialogPanel,true);
}

//display yes/no confirm dialog
function ConfirmDialog(title,text,currPanel,onYes,onNo,onData) {
	EV(dialogNo,true,true);
	dialogTitle.innerHTML = title;
	dialogText.innerHTML = text;
	dialogReturnPanel = currPanel;
	onDialogYes = onYes;
	onDialogNo = onNo;
	onDialogData = onData;
	
	EV(currPanel,false);
	EV(dialogPanel,true);
}

//confirm deletion
function ConfirmDeleteDialog(item,panel,onYes) {
	ConfirmDialog("Deletion Confirmation", "Are you certain you want to delete "+item+"?", panel, onYes);
}

//update project settings
function UpdateProjectSettings() {
	UpdateCSSStyle();
	
	lockFps = projectConfig["LockFPS"].value;
	playHotkey = projectConfig["PlayHotkey"].value;
	captureMouse = projectConfig["CaptureMouse"].value;

	var hlOn = projectConfig["ToggleHighlight"].value;
	glslEditor.highlighting = hlOn ? glslHighlight : null;
	glslEditor.indentString = projectConfig["TabAsSpaces"].value ? " ".repeat(projectConfig["TabSize"].value) : "\t";
	if (hlOn) glslEditor.highlightDelay = IdToHighlightDelay(projectConfig["HighlightRate"].value);
	EV(glslEditor.highlight, hlOn);
	
	var fsCode = projectConfig["FullscreenCode"].value;
	EV(quickGLCanvas, !fsCode);
	sidePanel.style.width = fsCode ? "99.5vw" : "";
}


//regenerate css style
function UpdateCSSStyle() {
	var css = document.getElementById(THEMES[projectConfig["HighlightTheme"].value].split(" ").join("")+"StyleCSS").textContent.substring(1),
		wrap = projectConfig["TextWrap"].value;
		
	css += "div.HLCode, #GLSLCode {\n";
	if (wrap) css += "\tword-break: break-all;\n";
	css += "\twhite-space: "+(wrap?"pre-wrap":"pre")+";\n";
	css += "\tfont-size: "+projectConfig["FontSize"].value+"px;\n";
	css += "\ttab-size: "+projectConfig["TabSize"].value+";\n";
	css += "\tfont-family: 'Lucida Console', monospace;\n";
	css += "}";

	cssStyle.innerText = css;
}


//update image layer info
function UpdateImageLayer() {
	imageLayerInfo.innerHTML = "";
	imageLayerInfo.appendChild(document.createTextNode(layer.image.width+"x"+layer.image.height));
	imageLayerInfo.appendChild(layer.image);
}


//set layer config layer
function SetConfigLayer(id) {
	layerId = id;
	layer = layers[id];
	var lastPass = (layer.type===LAYERTYPE_PASS && passes.length===1);

	layersConfig["LayersSelect"].SetSelectOptions(GetLayerNames(), id);
	layersConfig["LayersName"].SetValue(layer.name);
	layersConfig["LayersType"].SetSelectOptions(lastPass ? LAYERTYPE_PASSNAME : LAYERTYPE_NAMES, layer.type);
	layersConfig["LayersType"].SetValue(layer.type);
	
	switch (layer.type) {
		case LAYERTYPE_PASS:
			var pres = ["Display Resolution"];
			if (!lastPass) {
				pres.push("Fixed Resolution");
				for (var i = 0; i < id; i++) pres.push("Layer"+i+" Resolution");
			}
			layersConfig["PassResolution"].SetSelectOptions(pres, layer.resolution);
		
			layersConfig["PassWidth"].SetValue(layer.fixedWidth);
			layersConfig["PassHeight"].SetValue(layer.fixedHeight);
			break;
			
		case LAYERTYPE_IMAGE:
			layersConfig["ImageMipMap"].SetValue(layer.mipMaps);
			layersConfig["ImageLinear"].SetValue(layer.linearFiltering);
			layersConfig["ImageRepX"].SetValue(layer.repeatX);
			layersConfig["ImageRepY"].SetValue(layer.repeatY);
			break;
			
		case LAYERTYPE_JSON:
			layersConfig["JSONFormat"].SetValue(layer.channels);
			break;
	}
	
	var active = layerTypeConfigs[layer.type];
	if (active) EV(active,true);
	for (var i = 0, l = layerTypeConfigs.length; i < l; i++) {
		var ele = layerTypeConfigs[i];
		if (ele && ele !== active) EV(ele, false);
	}
}

//update layer settings
function UpdateLayerSettings() {
	layer.name = layersConfig["LayersName"].value;
	
	switch (layer.type) {
		case LAYERTYPE_PASS:
			layer.resolution = layersConfig["PassResolution"].value;
			layer.fixedWidth = layersConfig["PassWidth"].value;
			layer.fixedHeight = layersConfig["PassHeight"].value;
			break;
		
		case LAYERTYPE_IMAGE:
			layer.mipMaps = layersConfig["ImageMipMap"].value;
			layer.linearFiltering = layersConfig["ImageLinear"].value;
			layer.repeatX = layersConfig["ImageRepX"].value;
			layer.repeatY = layersConfig["ImageRepY"].value;
			
			gl.bindTexture(gl.TEXTURE_2D, layer.texture);
			SetTextureOptions(layer.linearFiltering, layer.mipMaps, layer.repeatX, layer.repeatY);
			if (layer.mipMaps) gl.generateMipmap(gl.TEXTURE_2D);
			break;
			
		case LAYERTYPE_JSON:
			layer.channels = layersConfig["JSONFormat"].value;
			break;
		
	}
}

//update glsl changes
function UpdateLayerGLSL() {
	if (layer.type === LAYERTYPE_PASS || layer.type === LAYERTYPE_SHAREDGLSL) {
		if (glslEditor.codeLastChanged > layer.lastChanged) {
			layer.glsl = glslEditor.text.value;
			layer.lastChanged = glslEditor.codeLastChanged;
		}
	}
}

//set selected sidebar layer
function SetSidebarLayer(id) {
	layerId = id;
	layer = layers[id];
	layerName.textContent = layer.name;
	
	switch (layer.type) {
		case LAYERTYPE_IMAGE:
			UpdateImageLayer();
			break;
			
		case LAYERTYPE_PASS:
		case LAYERTYPE_SHAREDGLSL:
			glslEditor.SetText(layer.glsl);
			break;
	}

	var active = layerTypePanels[layer.type];
	if (active) EV(active,true);
	for (var i = 0, l = layerTypePanels.length; i < l; i++) {
		var ele = layerTypePanels[i];
		if (ele && ele !== active) EV(ele, false);
	}
}

//play/pause animation
function PlayAnimation(play) {
	playing = play;
	if (playing) {
		if (projectConfig["FullscreenCode"].value) {
			EV(quickGLCanvas,true);
			quickGLCanvas.requestFullscreen();
		}
		
		//update currently selected layer
		UpdateLayerGLSL();
	
		//generate shared glsl and check if changed
		var sharedGlsl = "", sharedLastChanged = -1;
		for (var i = 0; i < layers.length; i++) {
			var l = layers[i];
			if (l.type === LAYERTYPE_SHAREDGLSL) {
				sharedGlsl += l.glsl+"\n\n";
				sharedLastChanged = Math.max(sharedLastChanged, l.lastChanged);
			}
		}
	
		//recompile pass layers if changed
		for (var i = 0; i < layers.length; i++) {
			var l = layers[i];
			if (l.type === LAYERTYPE_PASS) {
				var change = Math.max(l.lastChanged,sharedLastChanged);
				if (change > l.lastCompiled) {//layer changed recompile
					if (!displayingCompile) {
						EV(glslCompiling,true);
						displayingCompile = true;
					}
					
					l.finalGlsl = fragShaderHead+sharedGlsl+l.glsl;
					if (!RecompilePassLayer(i,l)) {
						playing = false;
						return;
					}
					
					l.lastCompiled = change;
				}
			}
		}
		if (displayingCompile || displayResized) {
			//after compiling recompute rendertexture dependancy graph
			ComputePassDependencies();
		
			EV(glslCompiling,false);
			displayingCompile = false;
			displayResized = false;
		}
		if (displayingErrors) {
			EV(glslErrorsPanel,false);
			displayingErrors = true;
		}
		
		//initialize frame timer
		if (lockFps === 0) {
			animationRefTime = Date.now()-sidebarInput["AnimTime"].value*1000;
		} else {
			animationTime = sidebarInput["AnimTime"].value;
			animationRefTime = 0;
		}
		
		lastTime = Date.now();
		
	} else {
		if (captureMouse) document.exitPointerLock();
	}
	
	EV(playIcon,!playing,true);
	EV(pauseIcon,playing,true);
}


//display message about needing at least 1 layer
function CantDeleteLastLayer(panel) {
	MessageDialog("Can't Delete Layer", "Must have at least 1 GLSL rendering pass to output to the display.", panel);
}


//finish creating new project
function OnLoadNewProjectTemplate(id,data) {
	if (data) {
		ProjectFromJSON(JSON.parse(data));
		
	} else {
		layers.push(layer = new PassLayer("New Layer",glslEditor.text.value));
		passes.push(layer);
		layerId = 0;
	}
	sidebarInput["Layers"].SetSelectOptions(GetLayerNames(), 0);
	
	SaveProjects();
	SaveProject();
	loadingData = false;
	
	//close panel
	appStatus = APPSTATUS_PROJECT;
	EV(newProjectPanel,false);
	EV(projectPanel,true);
}

//load project
function OnLoadOpenProject(id,data) {
	FreeProject();
	if (data) {
		try {
			ProjectFromJSON(JSON.parse(data));
		} catch (e) {}
	}
	sidebarInput["Layers"].SetSelectOptions(GetLayerNames(), 0);
	
	SaveProjects();
	loadingData = false;
	
	//close panel
	appStatus = APPSTATUS_PROJECT;
	EV(openProjectPanel,false);
	EV(projectPanel,true);
}


//delete current project
function OnProjectDeleteYes() {
	if (loadingData) return;
	
	IndexedStorage_Delete("Project_"+project.id);
	FreeProject();
	projects.splice(0,1);
	project = projects[0];
	
	loadingData = true;
	IndexedStorage_Load("Project_"+project.id, OnLoadOpenProject);
}

//on loaded exported project json
function OnProjectImportLoad(e) {
	var f = e.target.files;
	if (f && f.length) {
		var fr = new FileReader();
		fr.onload = OnProjectImport;
		fr.readAsText(f[0]);
	}
}

function OnProjectImport(e) {	
	var json = null;
	try {
		json = JSON.parse(e.target.result);
	} catch(e) {}
	if (!json) {
		MessageDialog("Import Error", "Project file is not valid.", projectPanel);
		return;
	}

	FreeProject();
	CreateNewProject(null);	
	ProjectFromJSON(json);
	project.name = projectConfig["ProjectName"].value;
	
	SaveProjects();
	SaveProject();
}



//delete layer from main panel
function OnMainLayerDeleteYes() {
	layer.Delete();
	layers.splice(layerId,1);
	
	var newInd = Math.min(layerId,layers.length-1);
	sidebarInput["Layers"].SetSelectOptions(GetLayerNames(), newInd);
	SetSidebarLayer(newInd);
}

//delete layer from layer config panel
function OnLayerDeleteYes() {
	UpdateLayerSettings();
	
	layer.Delete();
	layers.splice(layerId,1);
	
	SetConfigLayer(Math.min(layerId,layers.length-1));
}



//on load image texture
function OnImageFileLoad(e) {
	var f = e.target.files;
	if (f && f.length) {
		var fr = new FileReader();
		fr.onload = OnImageRead;
		fr.readAsDataURL(f[0]);
	}
}
function OnImageRead(e) {
	if (layer.type !== LAYERTYPE_IMAGE) return;
	
	layer.image.onload = OnImageLoad;
	layer.image.src = e.target.result;
}




//find arrays within json objects
function FindJSONArrays(name,obj) {
	for (var k in obj) {
		var o = obj[k];
		if (Array.isArray(o)) {
			layer.arrayNames.push(name+k);
			layer.arrays.push(o);
		}
		
		if (typeof(o) === "object") FindJSONArrays(name+k+".", o);
	}
}

//on load json file
function OnJSONFileLoad(e) {
	var f = e.target.files;
	if (f && f.length) {
		var fr = new FileReader();
		fr.onload = OnJSONRead;
		fr.readAsText(f[0]);
	}
}
function OnJSONRead(e) {
	if (layer.type !== LAYERTYPE_JSON) return;
	
	var js = null;
	try {
		js = JSON.parse(e.target.result);
	} catch (e) {}
	if (!js) return;
	
	layer.arrayNames = [];
	layer.arrays = [];
	if (Array.isArray(js)) {
		layer.arrayNames.push("root");
		layer.arrays.push(js);
	}
	FindJSONArrays("",js);
	
	layersConfig["JSONSelect"].SetSelectOptions(layer.arrayNames, 0);
	SelectJSONArray(0);
}

