#version 150
precision highp float; precision highp int;
//Ethan Alexander Shulman 2022 "Blood Lines" July 21, 2022

in vec3 in_Position;
out vec4 uv;
out float time;

layout(std140) uniform ShaderviewBlock {
	vec4 mouse;
	float screenX,screenY;
	int frame,framerate;
};

#define AA_SAMPLES 32

#define PI 3.141592653589793

mat2 r2d(float a) {
	float c = cos(a), s = sin(a);
	return mat2(c,s,-s,c);
}
//r2 hash http://extremelearning.com.au/unreasonable-effectiveness-of-quasirandom-sequences/
vec2 quasiRandom(float n) {
	#define R2V 1.32471795724474602596
	return fract(.5+n*(1./vec2(R2V,R2V*R2V)));
}


float line(vec2 p, vec2 a, vec2 b) {
	vec2 pa = p-a, ba = b-a;
	return length(pa-ba*clamp(dot(pa,ba)/dot(ba,ba),0.,1.));
}

vec3 hue(float h) {
	return clamp(abs(mod(h*6.+vec3(0.,4.,2.),6.)-3.)-1.,0.,1.);
}

uniform sampler2D Buffer0;

void vert() {
	time = mod(float(frame)/float(framerate*AA_SAMPLES),60.);//animation
	//time = 20.;//screenshot 1
	//time = 60.;//screenshot 2
	uv = vec4((in_Position.xy*vec2(screenX/screenY,1)+(quasiRandom(float(frame%AA_SAMPLES))-.5)*2./screenY),
		(in_Position.xy*.5+.5)*vec2(screenX,screenY));
	gl_Position = vec4(in_Position,1);
}
void frag() {
	vec2 p = uv.xy;
	for (float f = 1.; f < 100.; f += f) {
		float ang = atan(p.y,p.x)*f;
		p += (vec2(cos(ang),sin(ang))*cos(length(p)*(.9+cos(time/10.*PI*2.)*.1)*f)-p)*time/60.*.06;
	}

	float len = length(p),
		vcos = cos(atan(p.y,p.x)*10.*pow(2.,floor(len*4.))),
		veins = clamp(vcos*2.-1.,0.,1.);
	vec3 c = mix(vec3(.008,0,0)+(vcos*.5+.5)*vec3(.1,.2,1),
				mix(mix(vec3(.8,.003,.1),vec3(.2,.00004,.00002),pow(veins,.4)),
				vec3(.3,.02,.1),cos(len*22.-time*5.)*.5+.5),veins);
	
	vec4 sum = texelFetch(Buffer0,ivec2(uv.zw),0);
	if (frame%AA_SAMPLES == 0) sum = vec4(0);
	sum += vec4(c, 1.);
	gl_FragColor = sum;
}
