//BL2 Ground Item Radar by Ethan Alexander Shulman http://mnix.net/
//This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//http://creativecommons.org/licenses/by-nc-sa/4.0/

#include <stdio.h>
#include <d3dx9.h>



struct PAD3 {//12 bytes of padding
	int a, b, c;
};
struct PAD4 {//16 bytes of padding
	int a, b, c, d;
};
struct PAD8 {//32 bytes of padding
	int a, b, c, d, e, f, g, h;
};

struct BLPlayer {//0x00   might be camera or gun doesn't seem like the player
	PAD8 pad1, pad2, pad3, pad4, pad5, pad6, pad7, pad8, pad9, pad10;
	int pi1;

	D3DXVECTOR3 position1;
	D3DXVECTOR3 position2;
	D3DXVECTOR3 position3;
	D3DXVECTOR3 position4;
	D3DXVECTOR3 position5;
	D3DXVECTOR3 position6;
	D3DXVECTOR3 position7;
	D3DXVECTOR3 position8;
	D3DXVECTOR3 position9;
	D3DXVECTOR3 position10;

	int pi2;

	PAD8 pad11, pad12;
	
	int pi3, pi4;

	D3DXVECTOR3 look1;
	int pi5;
	D3DXVECTOR3 look2;
};

struct GroundItem {
	PAD8 pad1, pad2, pad3;
	D3DXVECTOR3 position;
};
struct DArray {
	DWORD *items;
	DWORD length;
};

DWORD ItemIconColor, MinimapColor;
float MinimapX, MinimapY, MinimapS, MinimapReach, MinimapReach2;

float wndW, wndH, drawX,drawY;
RECT wndRect;
HWND blWnd;

IDirect3DTexture9 *iconTex,*radarTex;
ID3DXFont *arialFont;
ID3DXSprite *iconSprite=nullptr;


#define READ_DELAY 30
int readWait;

DWORD procBase,pb;
const DWORD groundItemArrayOffsets[3] = { 0x1ED5D54 , 0x144, 0x184 };
const DWORD playerPtrOffset = 0x01EC728C;

bool hasGroundItemArray;
DArray *groundItemArray;
bool hasPlayer;
BLPlayer *player;


void CreateD3DXFont(IDirect3DDevice9 *d9d, ID3DXFont **font, int fontSize, LPCSTR fontFamily) {
	D3DXCreateFont(d9d, fontSize, 0, FW_NORMAL, 1, false, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, fontFamily, font);
}

void parseLine(char *ln, int lnLen, char notif, char *out1, char *out2, int out1Len, int out2Len) {
	int oc = 0;
	int li = 0;
	char cb;

	while (li < lnLen && oc < out1Len) {
		cb = ln[li];
		if (cb == notif) {
			out1[oc] = '\0';
			break;
		}
		if (cb == '\0' || cb == '\n') {
			out1[oc] = '\0';
			return;
		}
		out1[oc] = cb;
		li++;
		oc++;
	}
	if (li >= lnLen || oc >= out1Len) {
		out1[oc] = '\0';
		return;
	}
	li++;
	oc = 0;

	while (li < lnLen && oc < out2Len) {
		cb = ln[li];
		if (cb == '\n' || cb == '\0') {
			out2[oc] = '\0';
			return;
		}
		out2[oc] = cb;
		li++;
		oc++;
	}
	if (li >= lnLen || oc >= out2Len) {
		out2[oc] = '\0';
		return;
	}
}

HWND GetBL2Window(IDirect3DDevice9 *d9d) {
	D3DDEVICE_CREATION_PARAMETERS d3dcp;
	d9d->GetCreationParameters(&d3dcp);
	return d3dcp.hFocusWindow;
}

bool IsMemoryReadable(DWORD addr) {
	MEMORY_BASIC_INFORMATION mem;
	if (VirtualQuery((void*)addr, &mem, sizeof(mem)) == 0) return false;

	if (mem.State != MEM_COMMIT) return false;
	if (mem.Protect == PAGE_NOACCESS || mem.Protect == PAGE_EXECUTE) return false;

	return true;
}
DWORD Pointers(DWORD base, DWORD *offset, DWORD numOffsets) {
	DWORD read = base;

	int mom = numOffsets - 1;
	for (int i = 0; i < mom; i++) {
		read += offset[i];

		if (!IsMemoryReadable(read)) return 0;
		read = *(DWORD*)read;
		if (read == 0) return 0;
	}

	read += offset[mom];
	if (!IsMemoryReadable(read)) return 0;
	return read;
}

bool IsInGame() {//check if ui is open, 0 = ui open
	return (*(byte*)(procBase + 0x1ED47B4)) != 0;
}

void UpdateWindowSize() {
	bool ret = GetWindowRect(blWnd, &wndRect);
	while (!ret) {
		ret = GetWindowRect(blWnd, &wndRect);
	}
	wndW = wndRect.right - wndRect.left;
	wndH = wndRect.bottom - wndRect.top;

	drawX = wndW/MinimapS*MinimapX;
	drawY = wndH/MinimapS*MinimapY;
}


float clampZeroOne(float f) {
	return f>1.f ? 1.f : (f < 0.f ? 0.f : f);
}

extern "C" void __declspec(dllexport) __fastcall Render(IDirect3DDevice9 *d3d9Dev) {

	if (hasPlayer && hasGroundItemArray && IsInGame()) {
		if (groundItemArray->items == 0) {
			hasGroundItemArray = false;
			return;
		}
		D3DXVECTOR3 iconPos, giPos, playerPos = player->position1+D3DXVECTOR3(134.f, 212.f, 0.f);// -D3DXVECTOR3(269.f, 422.f, 0.f);
		float hsi = player->look1.x;
		float hco = player->look1.y;
		float hx, hy = sqrtf(hsi*hsi+hco*hco);
		hsi /= hy;
		hco /= hy;//normalize

		/*
		char posOut[256];
		sprintf_s(posOut, "Pos: %.1f,%.1f,%.1f",playerPos.x,playerPos.y,playerPos.z);
		RECT porct;
		SetRect(&porct,0, 0, 300, 22);
		arialFont->DrawTextA(0, posOut, -1, &porct, DT_LEFT | DT_NOCLIP, 0xff00ffff);
		*/

		HRESULT res = iconSprite->Begin(D3DXSPRITE_ALPHABLEND);
		
		//scale
		D3DXMATRIX scaleMat = { MinimapS, 0.f, 0.f, 0.f,
			0.f, MinimapS, 0.f, 0.f,
			0.f, 0.f,MinimapS, 0.f,
			0.f, 0.f, 0.f, 1.f };
		iconSprite->SetTransform(&scaleMat);

		iconPos.x = drawX;
		iconPos.y = drawY;
		iconSprite->Draw(radarTex, 0, 0, &iconPos, MinimapColor);
		for (int i = 0; i < groundItemArray->length; i++) {
			giPos = ((GroundItem*)(groundItemArray->items[i]))->position;
			hx = giPos.x - playerPos.x;
			hy = giPos.y - playerPos.y;
			iconPos.x = drawX + clampZeroOne(((hx*hco - hy*hsi) + MinimapReach2) / MinimapReach)*512.f - 16.f;
			iconPos.y = drawY + clampZeroOne(((hx*hsi + hy*hco) + MinimapReach2) / MinimapReach)*512.f - 16.f;
			//iconPos.x = drawX + (hx + MinimapReach2) / MinimapReach*512.f; no rotation, for debugging
			//iconPos.y = drawY + (hy + MinimapReach2) / MinimapReach*512.f;

			iconSprite->Draw(iconTex, 0, 0, &iconPos, ItemIconColor);
		}
		iconSprite->End();
	}

	readWait++;
	if (readWait > READ_DELAY) {
		readWait = 0;

		if (!hasPlayer) {
			pb = procBase + playerPtrOffset;
			if (!IsMemoryReadable(pb)) return;
			pb = *(DWORD*)pb;
			if (pb == 0) return;

			player = (BLPlayer*)pb;
			hasPlayer = true;
		}

		hasGroundItemArray = false;
		pb = Pointers(procBase, (DWORD*)groundItemArrayOffsets, 3);
		if (pb == 0) return;

		groundItemArray = (DArray*)pb;
		hasGroundItemArray = true;
	}

}


void InitWindowSize(IDirect3DDevice9 *d3d9Dev) {
	Sleep(2000);

	blWnd = GetBL2Window(d3d9Dev);
	UpdateWindowSize();
}
extern "C" void __declspec(dllexport) __fastcall InitDirectX(IDirect3DDevice9 *d3d9Dev) {

	CreateThread(0, 0, (LPTHREAD_START_ROUTINE)InitWindowSize, d3d9Dev, 0, 0);

	CreateD3DXFont(d3d9Dev, &arialFont, 20, "Arial");

	D3DXCreateTextureFromFile(d3d9Dev,"Mods\\BL2ItemsOnMinimapRes\\icon.png",&iconTex);
	D3DXCreateTextureFromFile(d3d9Dev, "Mods\\BL2ItemsOnMinimapRes\\radar.png", &radarTex);
	D3DXCreateSprite(d3d9Dev, &iconSprite);
}

extern "C" void __declspec(dllexport) __fastcall ResetDirectX(IDirect3DDevice9 *d3d9Dev) {
	UpdateWindowSize();
	if (d3d9Dev && iconSprite) {
		arialFont->OnLostDevice();
		iconSprite->OnLostDevice();

		arialFont->OnResetDevice();
		iconSprite->OnResetDevice();
	}
}


void Init() {
	procBase = (DWORD)GetModuleHandle("Borderlands2.exe");
	hasPlayer = hasGroundItemArray = false;
	readWait = 0;

	//default settings
	MinimapX = MinimapY = 0.f;
	MinimapS = .5f;
	MinimapReach = 10000.f;
	MinimapReach2 = MinimapReach / 2.f;
	MinimapColor = 0xFFFFFFFF;
	ItemIconColor = 0xFFFF40FF;

	//load settings
	FILE *fp;
	if (fopen_s(&fp, "Mods\\BL2ItemsOnMinimapRes\\BL2ItemsOnMinimap.ini", "r") != 0)  return;

	char ln[64], tag[32], val[16];
	while (!feof(fp)) {
		fgets(ln, 64, fp);
		parseLine(ln, 63, '=', tag, val, 31, 15);

		if (strcmp(tag, "Minimap X") == 0) {
			MinimapX = atof(val);
			continue;
		}
		if (strcmp(tag, "Minimap Y") == 0) {
			MinimapY = atof(val);
			continue;
		}
		if (strcmp(tag, "Minimap Scale") == 0) {
			MinimapS = atof(val);
			continue;
		}
		if (strcmp(tag, "Minimap Color") == 0) {
			MinimapColor = strtoul(val, 0, 16);
			continue;
		}
		if (strcmp(tag, "Minimap Range") == 0) {
			MinimapReach = atof(val);
			MinimapReach2 = MinimapReach / 2;
			continue;
		}
		if (strcmp(tag, "Icon Color") == 0) {
			ItemIconColor = strtoul(val, 0, 16);
		}
	}

	fclose(fp);
}

bool WINAPI DllMain(HINSTANCE hInst, DWORD reason, LPVOID reserved) {
	if (reason == DLL_PROCESS_ATTACH) {
		Init();
	}
	return true;
}