//BL2ModLauncher by Ethan Alexander Shulman http://mnix.net/
//This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//http://creativecommons.org/licenses/by-nc-sa/4.0/

/*

v0 - Basic launcher doesn't support enabling/disabling mods yet

*/

#include "resource.h"
#include <stdio.h>
#include <tchar.h>
#include <Psapi.h>
#include <windows.h>

struct Mod {
	bool enabled;
	char fileName[MAX_PATH];
};

HWND dlgWnd;
bool launched;

int nMods;
Mod *mods;

char *TITLE = "BL2 Mod Launcher v0";
#define mb(msg) MessageBox(0,msg,TITLE,0)

void Init(HWND wnd) {
	launched = false;
	dlgWnd = wnd;

	//load mods into listboxes
	HWND onList = GetDlgItem(wnd, ID_ONLIST);
	for (int i = 0; i < nMods; i++) {
		SendMessage(onList, LB_INSERTSTRING, i, (LPARAM)mods[i].fileName);
	}
}

void WriteSettings() {
	FILE *fp;
	fopen_s(&fp, "BL2ModSettings.ini", "w");
	for (int i = 0; i < nMods; i++) {
		fprintf(fp, "%s=%d\n", mods[i].fileName, (int)mods[i].enabled);
	}
	fclose(fp);
}
void SetLaunched(bool l) {
	launched = l;
	EnableWindow(GetDlgItem(dlgWnd, ID_LAUNCH), !launched);
}
void Launch() {
	SetLaunched(true);

	WriteSettings();

	STARTUPINFO su;
	PROCESS_INFORMATION pi;

	//(LPVOID)CREATE_UNICODE_ENVIRONMENT possibly needed 
	if (!CreateProcess("Borderlands2.exe", 0, 0, 0, false, NORMAL_PRIORITY_CLASS | CREATE_SUSPENDED, 0, 0, &su, &pi)) {
		mb("Failed to create process Borderlands2.exe process, make sure BL2ModLauncher.exe is in the same folder as Borderlands.exe.");
		SetLaunched(false);
		return;
	}

	void *dllInjName = VirtualAllocEx(pi.hProcess, 0, 24, MEM_COMMIT, PAGE_READWRITE);
	WriteProcessMemory(pi.hProcess, dllInjName, "BL2ModHandler.dll", 17, 0);
	HANDLE remThread = CreateRemoteThread(pi.hProcess, NULL, 0, (LPTHREAD_START_ROUTINE)GetProcAddress(GetModuleHandle("Kernel32"), "LoadLibraryA"), dllInjName, 0, NULL);
	WaitForSingleObject(remThread, INFINITE);
	VirtualFreeEx(pi.hProcess, dllInjName, 24, MEM_RELEASE);

	ResumeThread(pi.hThread);

	SetLaunched(false);
}

BOOL CALLBACK OnWindowEvent(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
	switch (msg) {
	case WM_INITDIALOG:
		Init(hWnd);
		return TRUE;
		break;


	case WM_COMMAND:
	switch (LOWORD(wParam)) {
		case ID_LAUNCH:
			Launch();
		break;
	}
	break;



	case WM_QUIT:
		EndDialog(hWnd, 1);
		break;

	case WM_CLOSE:
		EndDialog(hWnd, 1);
		break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;

	default:
		return FALSE;
	}
	return TRUE;
}

void LoadMods() {

	//load all mod dlls in Mods directory
	nMods = 0;
	WIN32_FIND_DATA ffd;
	HANDLE hf = FindFirstFile("Mods\\*", &ffd);
	if (hf == INVALID_HANDLE_VALUE) {
		//failed to load any mods
		return;
	}

	int currModsSz = 2;
	mods = (Mod*)malloc(sizeof(Mod)*2);
	do {
		if (ffd.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) continue;

		if (nMods == currModsSz) {
			currModsSz *= 4;
			mods = (Mod*)realloc(mods,sizeof(Mod)*currModsSz);
		}
		int fl = strlen(ffd.cFileName);
		if (ffd.cFileName[fl - 1] != 'l' || ffd.cFileName[fl - 2] != 'l' || ffd.cFileName[fl - 3] != 'd') continue;
		memcpy(mods[nMods].fileName, ffd.cFileName, 260);
		mods[nMods].enabled = true;
		nMods++;
	} while (FindNextFile(hf, &ffd) != 0);
}

int WINAPI WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR args, int nCmd) {
	LoadMods();
	DialogBox(GetModuleHandle(0), MAKEINTRESOURCE(ID_WND), 0, OnWindowEvent);

	return 0;
}