//BL2 XP Display by Ethan Alexander Shulman http://mnix.net/
//This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//http://creativecommons.org/licenses/by-nc-sa/4.0/

#include <stdio.h>
#include <d3dx9.h>


ID3DXFont *font;
ID3DXSprite *sprite;

IDirect3DTexture9 *bgTex;


RECT fRect;

DWORD lastTime, nowTime,deltaTime;

int mC;
int moneyTimer;
int money,lastMoney;

char moneyStr[24];

DWORD moneyOffsets[3] = { 0x01ED4798 , 0x24, 0x2A0};
DWORD procBase;


bool IsMemoryReadable(DWORD addr) {
	MEMORY_BASIC_INFORMATION mem;
	if (VirtualQuery((void*)addr, &mem, sizeof(mem)) == 0) return false;

	if (mem.State != MEM_COMMIT) return false;
	if (mem.Protect == PAGE_NOACCESS || mem.Protect == PAGE_EXECUTE) return false;

	return true;
}
DWORD Pointers(DWORD base, DWORD *offset, DWORD numOffsets) {
	DWORD read = base;

	int mom = numOffsets - 1;
	for (int i = 0; i < mom; i++) {
		read += offset[i];

		if (!IsMemoryReadable(read)) return 0;
		read = *(DWORD*)read;
		if (read == 0) return 0;
	}

	read += offset[mom];
	if (!IsMemoryReadable(read)) return 0;
	return read;
}

extern "C" void __declspec(dllexport) __fastcall Render(IDirect3DDevice9 *d3d9Dev) {

	if (moneyTimer > 0) {

		money = Pointers(procBase, moneyOffsets, 3);
		if (money != 0) {
			money = *(DWORD*)money;
			if (money != lastMoney) {
				sprintf_s(moneyStr, "$%d", money);

				lastMoney = money;
				moneyTimer = 2400;
			}
		}

		nowTime = GetTickCount();
		moneyTimer -= nowTime - lastTime;
		lastTime = nowTime;

		sprite->Begin(D3DXSPRITE_ALPHABLEND);
		sprite->Draw(bgTex, 0, 0, &(D3DXVECTOR3(5, 200, 0)), 0xFFFFFFFF);
		sprite->End();

		fRect.left += 2;
		fRect.bottom += 2;
		font->DrawTextA(0, moneyStr, -1, &fRect, DT_LEFT | DT_NOCLIP, 0x90202020);
		fRect.left -= 2;
		fRect.bottom -= 2;
		font->DrawTextA(0, moneyStr, -1, &fRect, DT_LEFT | DT_NOCLIP, 0xFFFFFFFF);
	} else {
		mC++;
		if (mC > 24) {
			money = Pointers(procBase, moneyOffsets, 3);
			if (money != 0) {
				money = *(DWORD*)money;
				if (money != lastMoney) {
					sprintf_s(moneyStr, "$%d", money);

					lastMoney = money;
					moneyTimer = 2400;
					lastTime = GetTickCount();
				}
			}
			mC = 0;
		}
	}
}

extern "C" void __declspec(dllexport) __fastcall InitDirectX(IDirect3DDevice9 *d3d9Dev) {
	D3DXCreateTextureFromFile(d3d9Dev,"Mods\\money_bg.png",&bgTex);
	D3DXCreateSprite(d3d9Dev, &sprite);
	D3DXCreateFont(d3d9Dev, 28, 0, FW_NORMAL, 1, false, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "Arial", &font);
}

extern "C" void __declspec(dllexport) __fastcall ResetDirectX(IDirect3DDevice9 *d3d9Dev) {
	if (d3d9Dev && font) {
		font->OnLostDevice();
		font->OnResetDevice();

		sprite->OnLostDevice();
		sprite->OnResetDevice();
	}
}

void mrw(DWORD addr, DWORD sz) {
	DWORD old;
	VirtualProtect((LPVOID)addr, sz, PAGE_READWRITE, &old);
}
void mre(DWORD addr, DWORD sz) {
	DWORD old;
	VirtualProtect((LPVOID)addr, sz, PAGE_EXECUTE_READ, &old);
}
void Init() {
	procBase = (DWORD)GetModuleHandle("Borderlands2.exe");

	//patch money limit
	//sell to vending machine
	byte *bp = (byte*)(procBase + 0x73B46F);
	mrw((DWORD)bp,2);
	bp[0] = 0xEB;
	bp[1] = 0x24;
	mre((DWORD)bp, 2);

	//pickup bills
	bp = (byte*)(procBase + 0x69FE98);
	mrw((DWORD)bp, 5);
	bp[0] = bp[1] = bp[2] = bp[3] = bp[4] = 0x90;
	mre((DWORD)bp, 5);

	//receive from quest
	bp = (byte*)(procBase + 0x73B46F);
	mrw((DWORD)bp, 2);
	bp[0] = 0xEB;
	bp[1] = 0x24;
	mre((DWORD)bp, 2);

	mC = money = lastMoney = 0;
	SetRect(&fRect, 10, 200, 200, 20);
}

bool WINAPI DllMain(HINSTANCE hInst, DWORD reason, LPVOID reserved) {
	if (reason == DLL_PROCESS_ATTACH) {
		Init();
	}
	return true;
}