//BL2 XP Display by Ethan Alexander Shulman http://mnix.net/
//This work is licensed under a Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License.
//http://creativecommons.org/licenses/by-nc-sa/4.0/

#include <stdio.h>
#include <d3dx9.h>

ID3DXFont *font;

int fX, fY, fW, fH, offX, offY, fontSize;
int fontColor, font2Color;

char xpStr[64];
DWORD xpC,xpP;
float xp,lvl;

DWORD procBase;
DWORD xpOffsets[6] = { 0x01EC6E98, 0x3A8, 0x724, 0x398, 0x140, 0x6C };

void parseLine(char *ln, char notif, char *out1, char *out2) {
	int oc = 0;
	int li = 0;
	char cb;

	while (true) {
		cb = ln[li];
		if (cb == notif) {
			out1[oc] = '\0';
			break;
		}
		out1[oc] = cb;
		li++;
		oc++;
	}
	li++;
	oc = 0;

	while (true) {
		cb = ln[li];
		if (cb == '\n' || cb == '\0') {
			out2[oc] = '\0';
			return;
		}
		out2[oc] = cb;
		li++;
		oc++;
	}
}

bool IsMemoryReadable(DWORD addr) {
	MEMORY_BASIC_INFORMATION mem;
	if (VirtualQuery((void*)addr, &mem, sizeof(mem)) == 0) return false;

	if (mem.State != MEM_COMMIT) return false;
	if (mem.Protect == PAGE_NOACCESS || mem.Protect == PAGE_EXECUTE) return false;
	
	return true;
}
DWORD Pointers(DWORD base, DWORD *offset, DWORD numOffsets) {
	DWORD read = base;

	int mom = numOffsets - 1;
	for (int i = 0; i < mom; i++) {
		read += offset[i];

		if (!IsMemoryReadable(read)) return 0;
		read = *(DWORD*)read;
		if (read == 0) return 0;
	}

	read += offset[mom];
	if (!IsMemoryReadable(read)) return 0;
	return read;
}

bool IsInGame() {//check if ui is open, non zero = UI is open
	return *(byte*)(procBase + 0x1ED47B4) == 0;
}


const float oneDivTwo = 0.3571428571f;//1/2.8
extern "C" void __declspec(dllexport) __fastcall Render(IDirect3DDevice9 *d3d9Dev) {
	if (!IsInGame()) return;

	RECT rct;
	rct.left = fX+offX;
	rct.top = fY+offY;
	rct.right = fW;
	rct.bottom = fH;

	font->DrawTextA(0, xpStr, -1, &rct, DT_LEFT | DT_NOCLIP, font2Color);
	rct.left -= offX;
	rct.top -= offY;
	font->DrawTextA(0, xpStr, -1, &rct, DT_LEFT | DT_NOCLIP, fontColor);

	xpC++;
	if (xpC > 60) {
		xpP = Pointers(procBase, xpOffsets, 6);
		if (xpP == 0) {
			xpStr[0] = '\0';
			xpC = 0;
			return;
		}
		xp = *(float*)xpP;
		lvl = ceil(60.f*pow(ceil(pow((xp + 60.f) / 60.f, oneDivTwo)), 2.8f) - 60.f);//reverse borderlands leveling equation to get next level then recompute to get xp for next level, equation from the wiki here http://borderlands.wikia.com/wiki/Experience_Points
		sprintf_s(xpStr, "%.0f / %.0f", xp, lvl);
	}
}

extern "C" void __declspec(dllexport) __fastcall InitDirectX(IDirect3DDevice9 *d3d9Dev) {
	D3DXCreateFont(d3d9Dev, fontSize, 0, FW_NORMAL, 1, false, DEFAULT_CHARSET, OUT_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE, "Arial", &font);
}

extern "C" void __declspec(dllexport) __fastcall ResetDirectX(IDirect3DDevice9 *d3d9Dev) {
	if (d3d9Dev && font) {
		font->OnLostDevice();
		font->OnResetDevice();
	}
}

void Init() {
	xp = 0;
	xpC = 0;

	procBase = (DWORD)GetModuleHandle("Borderlands2.exe");

	//default settings
	fX = 20;
	fY = 20;
	offX = 1;
	offY = 1;
	fontSize = 12;
	fW = fontSize * 20;
	fH = fontSize + 4;
	fontColor = 0xFFFFFFFF;
	font2Color = 0x90202020;

	//load settings
	FILE *fp;
	if (fopen_s(&fp, "Mods\\BL2XPDisplay.ini", "r") != 0)  return;

	char ln[64],tag[32],val[16];
	while (!feof(fp)) {
		fgets(ln, 64, fp);
		parseLine(ln, '=', tag, val);

		if (strcmp(tag, "x") == 0) {
			fX = atoi(val);
		}
		if (strcmp(tag, "y") == 0) {
			fX = atoi(val);
		}
		if (strcmp(tag, "offset x") == 0) {
			offX = atoi(val);
		}
		if (strcmp(tag, "offset y") == 0) {
			offY = atoi(val);
		}
		if (strcmp(tag, "font size") == 0) {
			fontSize = atoi(val);
			fW = fontSize * 20;
			fH = fontSize + 4;
		}
		if (strcmp(tag, "font color") == 0) {
			fontColor = strtoul(val, 0, 0);
		}
		if (strcmp(tag, "shadow color") == 0) {
			font2Color = strtoul(val, 0, 0);
		}
	}

	fclose(fp);
}

bool WINAPI DllMain(HINSTANCE hInst, DWORD reason, LPVOID reserved) {
	if (reason == DLL_PROCESS_ATTACH) {
		Init();
	}
	return true;
}